<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;

use Mnv\Models\UserGroups;
use Mnv\Models\ContentType;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\Exceptions\NoContentException;

/**
 * Class ContentTypesAdmin
 */
class ContentTypesAdmin extends AdminMnv
{

    public function fetch()
    {

        $content = new ContentType($this->request);

        $this->smarty->assign('activeItem','articles');
        $this->smarty->assign('title', 'Настройка контента');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));


        /** удаление */
        if ($this->action == 'remove') {
            try {
                $content->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // Тип контента удален
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $content->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** изменение статуса */
        elseif ($this->action === 'status') {
            try {
                $content->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $content->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $content->status, 'message' => $e->getMessage(), 'type' => 'error');
            }

            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка */
        elseif ($this->action == 'reorder') {

            $i = 0;
            $content->data = [];
            foreach ($content->typeIds as $type) {
                $i++;
                $content->id = $type['id'];
                $content->data['orderBy']  = $i;
                $content->data['fileName'] = $type['fileName'];
                $content->update($content->data);
            }

            response()->json(array('status' => 200, 'message' => "Тип контента перемещен", 'type' => 'success'), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }


        /** получение всех менеджеров с картинками */
        $types = collect($content->all($this->limit = 30, $this->page))->map(function ($item) {
            return $item;
        })->all();

        /** pagination */
        $content->total();
        $pages = getPageNums($content->total, $this->page, $this->limit, 0, 4, 4, 0);

        $this->smarty->assign('types', $types);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        /** Права доступа к данному шаблону */
        if ($this->manager['userType'] == UserGroups::DEVELOPER) {
            return $this->smarty->fetch('views/contents/types.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}



