<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Core\Helpers;

use Mnv\Core\SortTable;
use Mnv\Models\Content;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\ContentType;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotContentApproveException;

/**
 * Class ContentsAdmin
 * @package Mnv\Admin\Controllers
 */
class ContentsAdmin extends AdminMnv
{

    public function fetch()
    {
        global $SECTIONS;

        $dateSelector = new StatsDateSelector(false, 'contentDateSelector');

        $content = new Content($this->request);
        $content->sortTableId = $this->module;
        /** title */
        $this->smarty->assign('title', ContentType::getContentTypeValue('name', $this->module));
        /** activeItem */
        $this->smarty->assign('activeItem', $this->module);
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);
        /** type content */
        $content->contentType = $this->request->get('contentType', $this->module);
        /** statuses */
        $statuses = lang('general:statuses');
        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);

        /** Получение разделов по типу контента */
        $sections = Helpers::getSectionContent(0, $content->contentType);

        /** удаление */
        if ($this->action === 'remove') {
            try {
                $content->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // lang('articles:messages:2')
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $content->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

            exit();
        }
        /** Изменение статуса */
        elseif ($this->action === 'status') {
            try {
                $content->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $content->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $content->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** одобрение */
        elseif ($this->action === 'approve') {
            try {
                $content->approve();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status,'message' => 'Запись была опубликована без предварительной модерации.', 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** добавление в избранное / удаление из избранного */
        elseif ($this->action === 'favorites') {
            try {
                $content->favorites();
                $status = \Mnv\Http\Response::HTTP_OK;
                $message =  $content->favorites == 1 ? 'Запись была добавлена в избранное.' : 'Запись была удалена из избранного.';
                $response = array('status' => $status, 'data' => $content->favorites, 'message' => $message, 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $content->favorites, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** Групповые действия  */
        elseif ($this->action === 'group') {
            if (!empty($content->group_action)) {
                if (!empty($content->contentIds)) {
                    foreach ($content->contentIds as $contentId) {
                        $content->id = $contentId;
                        $content->group();
                    }
                    $response = array('status' => 200, 'message' => 'Успешно выполнено', 'type' => 'success');
                } else {
                    $response =  array('status' => 500, 'message' => 'Необходимо выбрать контент', 'type' => 'error');
                }
            } else {
                $response =  array('status' => 500, 'message' => 'Необходимо выбрать действие', 'type' => 'error');
            }

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** Сортировать таблицу */
        elseif ($this->action === 'sort_table') {
            SortTable::init()->setSort($content->sortTableId, $content->sortBy, $content->sortOrder);
            $result = array('status' => 200, 'table' => $content->sortTableId, 'sortBy' => $content->sortBy, 'sortOrder' => $content->sortOrder);

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** Очистить сортировку таблицы */
        elseif ($this->action === 'clear_sort_table') {
            SortTable::init()->clearSort($content->sortTableId);
            $result = array('status' => 200, 'table' => $content->sortTableId);

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        else {
            /** Фильтровать контента */
            $content->filter = array_filter([
                'dateStart'     => $dateSelector->dateStart,
                'dateEnd'       => $dateSelector->dateEnd,
                'contentType'   => $content->contentType,
                'query'         => $this->query,
                'status'        => $this->filter['status'] ?? '',
                'section'       => $this->filter['section'] ?? '',

            ]);


            /** Получение всего контента */
            $contents = $content->all($this->limit, $this->page);
            $contents = collect($contents)->map(function ($item) use ($content, $SECTIONS) {
                $item['publishedOn'] = langDate(adjustTime($item['publishedOn'], false, 'd.m.Y'));
                $item['image']    = !empty($item['image']['small']) ? $item['image']['small'] : '/admin/assets/images/no_images.jpg';
                $item['section']  = isset($SECTIONS[$item['sectionId']]) ? $SECTIONS[$item['sectionId']]['name'] : '';
                $item             += $content->getCustomFieldsValues($item['articleId']);

                return $item;
            })->all();

//            print_r($contents);

            /** pagination */
            $content->total();
            $pages = getPageNums($content->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** Вывод в шаблон результатов */
            $this->smarty->assign('totalArticles', $content->total);
            $this->smarty->assign('articles', $contents);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('sections', $sections);
            $this->smarty->assign('contentType', $content->contentType);

        }


        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);
        if (!empty($this->action)) $this->smarty->assign('action', $this->action);

        /** Права доступа к данному шаблону */
        if ($this->permissions($this->module)) {
            return $this->smarty->fetch('views/contents/articles.tpl');
        }

        $this->smarty->assign('title', lang('general:accessIsDenied'));
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


}