<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\AdminMnv;
use Mnv\Models\UserGroups;

/**
 * Class DocumentDocsAdmin
 * @package Mnv\Admin\Controllers
 */
class DocumentDocsAdmin extends AdminMnv
{

    public function fetch()
    {
        $this->smarty->assign('activeItem', 'docs');
        $this->smarty->assign('title', 'Smarty');


        try {
            if ($this->manager['userType'] == UserGroups::DEVELOPER) {
                return $this->smarty->fetch('views/documents/smarty.tpl');
            }

            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');

        } catch (\SmartyException | \Exception $e) {
            return $e->getMessage();
        }
    }

}