<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;

use Mnv\Models\Form\Form;
use Mnv\Models\Form\FormField;
use Mnv\Models\UserGroups;

/**
 * Class FormAdmin
 */
class FormAdmin extends AdminMnv
{

    public function fetch()
    {

        $content = new Form($this->request);

        $this->smarty->assign('activeItem','forms');
        $this->smarty->assign('title', 'Настройка формы');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));
        $this->smarty->assign('methods', $content->methods);

        /** получить дополнительные поля по типу контента */
        $fields = collect(FormField::fields($content->id, ''))->map(function ($item) {
            $item['fieldTypeName'] = FormField::getFieldTypeName($item['fieldType']);
//            $item['inputTypeName'] = FormField::getInputTypeName($item['inputType']);
//            $item['buttonTypeName'] = FormField::getInputTypeName($item['buttonType']);
            $item['statusName'] = lang('general:statuses:' . $item['status']);

            $item['options']  = FormField::options($item['options']);
            $item['attributes']  = !empty($item['attributes']) ? json_decode($item['attributes'], true) : [];

            return $item;
        })->all();

        $this->smarty->assign('fields', $fields);

        $this->smarty->assign('typeFields', FormField::getFieldTypes());

        /** работа с галереей */
        $image    = $this->request->get('image', '');
        $imageId  = (int) $this->request->get('imageId', '');


        /** создание и редактирование */
        if ($this->action == 'edit' || $this->action == 'add') {

            $content->edit()->getFiles()->gettingInfoAboutUsers();
        }
        /** сохранение данных */
        else if ($this->action == 'save' || $this->action == 'apply') {

            if (empty($content->data['name'])) $this->errors['name'] = true;
            $content->data['enableCsrfToken'] = $content->data['enableCsrfToken'] ?? 0;

            if (empty($content->data['fileName'])) $this->errors['fileName'] = true;
            if (preg_match('/^(type\d+|contents|content)$/i', $content->data['fileName'])) $this->errors['fileNameProhibited'] = true;
            if (preg_match("/[^a-z\s]/iu", $content->data['fileName'])) $this->errors['fileNameCharacters'] = true;
            $content->data['fileName'] = strtolower($content->data['fileName']);

            if ($fileName = $content->checkFileName($content->data['fileName'])) {
                if ($fileName == $content->data['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $content->data['fileName'] = $fileName;
                }
            }


            /** основная картинка */
            $images['general'] = !empty($image) ? $image : null;

            if (empty($this->errors)) {
                if ($content->prepare($content->data, $this->manager['userId'])) {
                    if (!empty($images['general'])) $content->addFiles($content->id, $images);
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $content->edit()->getFiles()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString("forms", ['page' => $this->page]));
            }

        }
        /** удаление основной картинки */
        else if ($this->action == 'deleteFile') {
            $result = $content->deleteFile($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingFile'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingFileError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }


        $this->smarty->assign('form', $content->data);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        /** Права доступа к данному шаблону */
        if ($this->manager['userType'] == UserGroups::DEVELOPER) {
            return $this->smarty->fetch('views/feedbacks/form.tpl');
        }


        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}



