<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;

use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\Form\FormField;
use Mnv\Models\UserGroups;

/**
 * Class FormFieldAdmin
 */
class FormFieldAdmin extends AdminMnv
{

    public function fetch()
    {
        $field = new FormField($this->request);

        $this->smarty->assign('activeItem','forms');
        $this->smarty->assign('title', 'Добавить поле');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));
        /** type fields */
        $this->smarty->assign('fieldTypes', FormField::getFieldTypes());
        $this->smarty->assign('inputTypes', FormField::getInputTypes());
        $this->smarty->assign('buttonTypes', FormField::getButtonTypes());


        $this->smarty->assign('groupPositions', $field->groupPositions);


        if ($this->action == 'edit' || $this->action == 'add') {

            $field->edit()->gettingInfoAboutUsers();

            $this->smarty->assign('field', $field->data);
            $this->smarty->assign('options', $field->options);
            $this->smarty->assign('attributes', $field->attributes);
        }
        /** сохранение данных */
        elseif ($this->action == 'save' || $this->action == 'apply') {

            if (empty($field->data['label'])) $this->errors['label'] = true;
            if (empty($field->data['name'])) $this->errors['name'] = true;

//            if (preg_match('/[^a-zA-Z\-_\.,]/i', $field->data['name'])) $this->errors['nameCharacters'] = true;

            if (preg_match('/[^a-zA-Z_\-.,]/', $field->data['name'])) {
                $this->errors['nameCharacters'] = true;
            }

            if ($fileName = $field->checkFileName($field->data['name'])) {
                if ($fileName == $field->data['name']) {
                    $this->errors['nameExists'] = true;
                } else {
                    $field->data['name'] = $fileName;
                }
            }

            // параметры
            $field->data['options'] = !empty($field->options)
                ? json_encode($field->options, JSON_UNESCAPED_UNICODE)
                : null;

            // атрибуты
            $field->data['attributes'] = !empty($field->attributes)
                ? json_encode($field->attributes, JSON_UNESCAPED_UNICODE)
                : null;


            if (!isset($field->data['inputType'])) $field->data['inputType'] = NULL;

            if (in_array($field->data['fieldType'], array_keys(array_slice(FormField::getFieldTypes(), 0, -1, true)))) {
                $field->data['buttonType'] = null;
            }

            if (empty($this->errors)) {
                if ($field->prepare($field->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $field->edit()->gettingInfoAboutUsers();

            $this->smarty->assign('field', $field->data);
            $this->smarty->assign('options', $field->options);
            $this->smarty->assign('attributes', $field->attributes);

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString("form", ['action' => 'edit', 'id' => $field->formId]));
            }

        }
        /** удаление */
        elseif ($this->action == 'remove') {
            try {
                $field->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // Тип контента удален
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $field->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** изменение статуса */
        elseif ($this->action === 'status') {
            try {
                $field->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $field->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $field->status, 'message' => $e->getMessage(), 'type' => 'error');
            }

            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка */
        elseif ($this->action == 'reorder') {
            $i = 0;
            $field->data = [];
            foreach ($field->fieldIds as $fieldId) {
                $i++;
                $field->id = $fieldId;
                $field->data['orderBy'] = $i;
                $field->update($field->data);
            }
            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }


        $this->smarty->assign('fields', $field->all($this->limit = 50, $this->page));
        $this->smarty->assign('formId', $field->formId);


        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        /** Права доступа к данному шаблону */
        if ($this->manager['userType'] == UserGroups::DEVELOPER) {
            return $this->smarty->fetch('views/feedbacks/form-field.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}



