<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\GeoCountries;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Core\Database\Throwable\DatabaseException;

/**
 * Class GeoCountriesAdmin
 * @package Mnv\Admin\Controllers
 */
class GeoCountriesAdmin extends AdminMnv
{

    public function fetch()
    {

        $country = new GeoCountries($this->request);

        $this->smarty->assign('activeItem','countries');
        $this->smarty->assign('title', 'Страны');
        /** statuses */
        $statuses = lang('general:statuses');
        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $this->module);

        /** удаление */
        if ($this->action == 'remove') {
            try {
                $country->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // Город удален
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $country->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** изменение статуса */
        elseif ($this->action === 'status') {
            try {
                $country->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $country->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $country->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** фильтровать контента */
        $country->filter = array_filter([
            'query'         => $this->query,
            'status'        => $this->filter['status'] ?? '',

        ]);

        $countries = collect($country->all($this->limit, $this->page))->map(function ($item) {
            $item['statusName']  = lang('general:statuses:' . $item['status']);

            return $item;
        })->all();

        /** pagination */
        $country->total();
        $pages = getPageNums($country->total, $this->page, $this->limit, 0, 4, 4, 0);

        $this->smarty->assign('countries', $countries);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        /** Права доступа к данному шаблону */
        if ($this->permissions('countries')) {
            return $this->smarty->fetch('views/geo/geo.countries.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}



