<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\GeoCountries;

/**
 * Class GeoCountryAdmin
 * @package Mnv\Admin\Controllers
 */
class GeoCountryAdmin extends AdminMnv
{
    public function fetch()
    {

        $country = new GeoCountries($this->request);

        $this->smarty->assign('activeItem', 'countries');
        $this->smarty->assign('title', 'Страны');
        /** statuses */
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1));

        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/countries');

        if ($this->action == 'add' || $this->action == 'edit') {

            $country->edit()->gettingInfoAboutUsers();
        }
        /** сохранение данных */
        elseif ($this->action == 'save' || $this->action == 'apply') {

            if (empty($country->data['name'])) $this->errors['name'] = true;

            $country->data['translations'] = !empty($country->translations)
                ? json_encode(array_column($country->translations, 'name', 'key'), JSON_UNESCAPED_UNICODE)
                : null;

            if (empty($this->errors)) {
                if ($country->prepare($country->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $country->edit()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action === 'save') {
                redirect($this->buildQueryString("countries", ['page' => $this->page]));
            }
        }

        $country->data['translations'] = !empty($country->data['translations']) ? json_decode($country->data['translations'], true) : [];

        $this->smarty->assign('country', $country->data);

        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);
        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);


        /** Права доступа к данному шаблону */
        if ($this->permissions('countries')) {
            return $this->smarty->fetch('views/geo/geo.country.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}


