<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Models\Exceptions\GroupDeletionException;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\UserGroups;

/**
 * Class ManagerGroupsAdmin
 * @package Mnv\Admin\Controllers
 */
class ManagerGroupsAdmin extends AdminMnv
{

    /**
     * Вывод всех пользователей
     */
    public function fetch()
    {

        $userGroup = new UserGroups($this->request);

        $this->smarty->assign('activeItem', 'groups');
        $this->smarty->assign('title', "Группы пользователей");

        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1, 2, true));
        $this->smarty->assign('permission', $this->accessRights());

        /** удаление */
        if ($this->action == 'remove') {
            try {
                $userGroup->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // Пользователь удален
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $userGroup->status, 'message' => $e->getMessage(), 'type' => 'error');
            } catch (GroupDeletionException $e) {
                $status =  \Mnv\Http\Response::HTTP_BAD_REQUEST;
                $response = array('status' => $status, 'data' => $userGroup->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** изменение статуса */
        elseif ($this->action == 'status') {
            try {
                $userGroup->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $userGroup->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $userGroup->status, 'message' => $e->getMessage(), 'type' => 'error');
            } catch (GroupDeletionException $e) {
                $status =  \Mnv\Http\Response::HTTP_BAD_REQUEST;
                $response = array('status' => $status, 'data' => $userGroup->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        $groups = collect($userGroup->all($this->limit, $userGroup->total, $this->manager['userType']))->map(function ($item) use ($userGroup) {
            $item['countUsers']    = $userGroup->getCountGroupUsers($item['groupId']);
            $item['hasAdminAccessName']    = lang('general:choice:' . $item['hasAdminAccess']);
            $item['dateChange']    = langDate(adjustTime($item['modifiedOn'], false, 'd.m.Y H:i'));

            return $item;
        })->all();

        $this->smarty->assign('groups', $groups);

        /** pagination */
        $userGroup->total($this->manager['userType']);
        $pages = getPageNums($userGroup->total, $this->page, $this->limit, 0, 4, 4, 0);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }


        if ($this->permissions('groups')) {
            return $this->smarty->fetch('views/users/groups.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }


}
