<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Core\Filesystem\Filesystem;
use Mnv\Models\Maps;

/**
 * Class MapsAdmin
 * @package Mnv\Admin\Controllers
 */
class MapsAdmin extends AdminMnv
{

    private Filesystem $filesystem;
    private ?array $data = null;

    public function __construct()
    {
        parent::__construct();
        $this->filesystem = new Filesystem();
    }

    public function fetch()
    {

        $this->data = $this->request->get('map');

        $this->smarty->assign('activeItem','maps');
        $this->smarty->assign('title', lang('settings:title'));
        $this->smarty->assign('works', lang('general:works'));


        if ($this->action == 'save') {
            $this->buildMapsArray();

            $this->messages['saved'] = true;
        }

        $this->readMapsArray();

        $this->smarty->assign('map', $this->data);
        $this->smarty->assign('generate_script_map',  $this->generateScriptMap());

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if ($this->permissions('maps')) {
            return $this->smarty->fetch('views/maps/maps.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

    protected function buildMapsArray(): bool
    {

        $data = "<?php\r\n";
        $data .= ' return ' . var_export($this->data, true) . ';';

        $this->filesystem->put(GLOBAL_ROOT.'/includes/config.maps.inc.php', $data);

        return true;
    }

    protected function readMapsArray()
    {
        $this->data = require GLOBAL_ROOT.'/includes/config.maps.inc.php';
    }


    protected function generateScriptMap(): string
    {
        $coordinates = $this->parseCoordinates($this->data['coordinates'] ?? '0, 0');

        if ($this->data['type'] === 'yandex') {
            return $this->generateYandexMap($coordinates);
        }

        return $this->generateGoogleMap($coordinates);
    }

    private function parseCoordinates(string $coordinates): array
    {
        return explode(", ", $coordinates);
    }


    private function generateYandexMap(array $coordinates): string
    {
        return sprintf(
            '<style>#map-canvas {width: %s;height: %s;}</style>
        <script src="https://api-maps.yandex.ru/2.1/?load=package.full&amp;apikey=%s&amp;lang=ru_RU&onload=YandexMaps.init"></script>
        <script type="text/javascript">
            ymaps.ready(init);
            function init(){
                var myMap = new ymaps.Map("map-canvas", {
                    center: [%s, %s],
                    zoom: %s
                }, { searchControlProvider: "yandex#search" });
                myMap.behaviors.disable("scrollZoom");
                let myPlaceMark = new ymaps.Placemark ([%s, %s], {iconContent: " "}, { preset: "islands#bluePersonIcon"});
                myMap.geoObjects.add(myPlaceMark);
            }
        </script>',
            $this->data['maps_wight'],
            $this->data['maps_height'],
            htmlspecialchars($this->data['api_key']),
            $coordinates[0],
            $coordinates[1],
            $this->data['zoom'],
            $coordinates[0],
            $coordinates[1]
        );
    }


    private function generateGoogleMap(array $coordinates): string
    {
        return sprintf(
            '<style>#map-canvas {width: %s;height: %s;}</style>
        <script src="https://maps.googleapis.com/maps/api/js?key=%s"></script>
        <script type="text/javascript">
            function initialize() {
                var mapOptions = {
                    center: new google.maps.LatLng(%s, %s),
                    zoom: %s,
                    mapTypeId: google.maps.MapTypeId.ROADMAP
                };
                var map = new google.maps.Map(document.getElementById("map-canvas"), mapOptions);
            }
            google.maps.event.addDomListener(window, "load", initialize);
        </script>',
            $this->data['maps_wight'],
            $this->data['maps_height'],
            htmlspecialchars($this->data['api_key']),
            $coordinates[0],
            $coordinates[1],
            $this->data['zoom']
        );
    }

}


