<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Stats;

/**
 * Class StatsVisitorAdmin
 * @package Mnv\Admin\Controllers
 */
class StatsVisitorAdmin extends AdminMnv
{

    public function fetch()
    {
        $stats = new Stats();
        $dateSelector = new StatsDateSelector(false, 'visitorDateSelector');
        $typeSelector = new StatsTypeSelector();
        $sortVisits = false;

        $this->smarty->assign('activeItem','visitors');
        $this->smarty->assign('title', lang('stats:visitor'));

        $visitorId = (int) $this->request->get('visitorId');

        /** получить информацию о посетителе */
        $visitor = $stats->getStatsVisitor($visitorId);
        if (empty($visitorId) || empty($visitor)) die('Visitor Not Found');
        $visitor['firstVisitOn'] = langDate(adjustTime($visitor['firstVisitOn'], false, 'l, M d, Y - H:i'));

        if ($visitor['isBot']) {
            header("HTTP/1.0 301 Moved Permanently");
            header("Location: " . $this->adminUrl . "/bot?visitorId=$visitorId".(!empty($typeSelector->filterTypeId) ? "&filterTypeId=$typeSelector->filterTypeId" : ''));
            exit;
        }

        $visits = $stats->getStatsVisits($dateSelector->dateStart, $dateSelector->dateEnd, $typeSelector->filterTypeId, $visitorId, $this->limit, $this->page);
        if (!empty($visits)) {
            foreach ($visits as $visitId => $visit) {
                $visits[$visitId]['typeName']  = lang('visitTypes:'.$visit['typeId']);
                $visits[$visitId]['visitDate'] = langDate(adjustTime($visit['visitDate'], false, 'd.m.Y H:i:s'));
                $visitTypes[$visit['typeId']]  = $visit['typeId'];
            }

            /** section visits */
            if(!empty($visitTypes[2])) $visits = $stats->sectionVisits($visits);
            /** article visits */
            if (!empty($visitTypes[3])) $visits = $stats->articleVisits($visits);
            /** search visits */
            if (!empty($visitTypes[4])) $visits = $stats->searchVisits($visits);
            /** error visits */
            if (!empty($visitTypes[6])) $visits = $stats->errorVisits($visits);
            /** RSS visits */
            if (!empty($visitTypes[7])) $visits = $stats->rssVisits($visits);
        }

        /** page numbering */
        $totalItems = $stats->getTotalStatsVisits($dateSelector->dateStart, $dateSelector->dateEnd, $typeSelector->filterTypeId, $visitorId);
        $pages = getPageNums($totalItems, $this->page, $this->limit, 2, 1, 1, 2);
        $this->smarty->assign('pageNums', $pages);

        /** получить больше информации о посетителе */
        if (!empty($visitor['visitId']))
            $visitor['firstVisit'] = $stats->getVisitInfo($visits, $visitor['visitId']);

        /** отличия от статистикой бота */
        if (!empty($visitor['referer'])) $visitor += $stats->parseReferer($visitor['referer']);

        $this->smarty->assign('visitor', $visitor);

        /** сортировка посещений, потому что добавлены скрытые посещения */
        if ($sortVisits == true) usort($visits, array($stats, 'sortByVisitDate'));

        $this->smarty->assign('filterTypeOptions', $typeSelector->get());
        $this->smarty->assign('filterTypeId', $typeSelector->filterTypeId);
        $this->smarty->assign('visitorId', $visitorId);
        $this->smarty->assign('visits', $visits);


        if ($this->permissions('visitors')) {
            return $this->smarty->fetch('views/stats/visitor.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }








}