<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\AdminMnv;
use Mnv\Core\Filesystem\Filesystem;
use Mnv\Models\TelegramNotification;
use Mnv\Models\User;

/**
 * Class TelegramNotificationAdmin
 * @package Mnv\Admin\Controllers
 */
class TelegramNotificationAdmin extends AdminMnv
{

    public function fetch()
    {

        $telegram = new TelegramNotification($this->request);


        $this->smarty->assign('activeItem','telegrams');
        $this->smarty->assign('title', 'Настройки телеграм');

        $this->smarty->assign('statuses', array('V' => 'Включено', 'H' => 'Отключено'));

        $this->smarty->assign('logs', $telegram->logs);
        $this->smarty->assign('users', User::adminTelegramConfigUsers());
        $this->smarty->assign('callMeVars', $telegram->getTemplateVariables());
        $this->smarty->assign('feedbackVars', $telegram->getTemplateVariables());
        $this->smarty->assign('serviceVars', $telegram->getTemplateVariables());
        $this->smarty->assign('questionVars', $telegram->getTemplateVariables([
            '{type}' => 'Способ связи'
        ]));
        $this->smarty->assign('quickOrderVars', $telegram->getTemplateVariables([
            '{product_id}'  => 'ID продукта',
            '{quantity}'    => 'Кол-во',
            '{product_name}' => 'Название продукта'
        ]));
        
        $this->smarty->assign('orderVars', $telegram->getTemplateVariables([
            '{order_id}'        => 'Номер заказа',
            '{store_name}'      => 'Название магазина',
            '{user_fullName}'   => 'Ф.И.О.',
            '{user_firstname}'  => 'Имя',
            '{user_lastname}'   => 'Фамилия',
            '{user_email}'      => 'E-mail',
            '{user_phone}'      => 'Телефон',
            '{payment_method}'  => 'Способ оплаты',
            '{shipping_address}'=> 'Адрес доставки',
            '{shipping_date}'   => 'Дата и время доставки',
            '{shipping_method}' => 'Способ доставки',
            '{total}'           => 'Итого',
            '{message}'         => 'Комментарий',
            '{order_status}'    => 'Статус заказа',
            '{date_added}'      => 'Дата и время добавления',
            '{date_modified}'   => 'Дата и время изменения',
            '{cart_start}'      => 'Начало корзины',
            '{product_name}'    => '&nbsp;—&nbsp;Название товара',
            '{product_options}' => '&nbsp;—&nbsp;Опции товара',
            '{product_url}'     => '&nbsp;—&nbsp;Ссылка на товар',
            '{product_sku}'     => '&nbsp;—&nbsp;Артикул товара',
            '{product_price}'   => '&nbsp;—&nbsp;Цена товара',
            '{product_quantity}'=> '&nbsp;—&nbsp;Кол-во товара',
            '{product_total}'   => '&nbsp;—&nbsp;Итого товара',
            '{cart_finish}'     => 'Конец корзины'
        ]));

        /** setWebhook */
        if  ($this->action == 'set_webhook') {

            $timeout = !empty($telegram->data['timeout']) ? $telegram->data['timeout'] : '5';
            $result = $telegram->set_webhook($telegram->data['telegram_key'], $timeout);

            if (!empty($result)) {
                $telegram->updateConfigValue('telegram_key', $telegram->data['telegram_key']);
                $telegram->updateConfigValue('webhook', $result['webhook']);
            }

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
            exit;
        }
        /** clear log */
        else if ($this->action == 'clear_log') {

            if (empty($telegram->key)) {
                $this->sendErrorResponse(400, 'У вас нет прав для управления модулем');
            }

            // Определяем путь к файлу логов
            $file = ($telegram->key === 'telegram') ? GLOBAL_ROOT . '/temp/log/telegram.log' : false;

            if ($file && $telegram->clearFileContents($file)) {
                $this->sendJsonResponse(['status' => 200, 'message' => 'Логи успешно очищены!', 'type' => 'success']);
            } else {
                $this->sendErrorResponse(400, 'У вас нет прав для управления модулем');
            }

        }

        /** download log */
        else if ($this->action == 'download_log') {
            $response = [];
            $file = '';
            // Проверяем наличие ключа
            if (empty($telegram->key)) {
                $this->sendErrorResponse(400, 'У вас нет прав для управления модулем');
            }

            // Определяем лог-файл для указанного типа ключа
            if ($telegram->key === 'telegram') {
                $file = GLOBAL_ROOT . '/temp/log/telegram.log';
            }

            // Проверяем существование и размер файла
            if ($file && file_exists($file) && filesize($file) > 0) {
                $this->sendFileResponse($file, $telegram->key);
            }

            // Если файл отсутствует или пустой, заполняем ответ
            $this->sendErrorResponse(400, sprintf("Внимание: Ваш файл ошибок %s имеет размер %s!", basename($file), $file ? '0B' : 'не найден'));

        }

        /** сохранение настроек */
        else if ($this->action == 'save') {

            $telegram->buildTelegramArray();
        }
        /** помощь */
        else if ($this->action == 'help')
        {
            $response = array();

            if (empty($telegram->key)) {
                $response['error'] = 'У вас нет прав для управления модулем ';
            }

            if (!$response) {
                if (!empty($telegram->key)) {
                    // help_module
                    if ($telegram->key == 'help_module') {
                        $webhook = [];
                        if ($this->request->has('webhook') && ($this->request->post('webhook') != 'no') && ($this->request->post('webhook') != 'potential') && (strripos($this->request->post('webhook'), 'resolve?domain=') || strripos($this->request->post('webhook'), 'info?uri='))) {
                            $webhook['webhook'] = $this->request->post('webhook');
                        }

                        $this->smarty->assign('webhook', $webhook);
                        $response['header'] = $telegram->modal_headers[$telegram->key];

                    }
                    // webhook
                    elseif ($this->request->has('webhook')) {
                        if (($this->request->post('webhook') != 'no') && ($this->request->post('webhook') != 'potential') && (strripos($this->request->post('webhook'), 'resolve?domain=') || strripos($this->request->post('webhook'), 'info?uri='))) {
                            $data['webhook'] = $this->request->post('webhook');
                        } else {
                            $data['webhook'] = '';
                        }

                        $this->smarty->assign('webhook', $data);
                        $response['header'] = $telegram->modal_headers[$telegram->key];;
                    }
                    else {
                        $response['header'] = $telegram->modal_headers[$telegram->key];
                    }

                    $response['success'] = $this->smarty->fetch('views/telegrams/help/'. $telegram->key .'.tpl');
                } else {
                    $response['error'] = 'У вас нет прав для управления модулем';
                }
            }


            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
            exit();
        }

        $telegram->readTelegramArray();

        /**  получить обновленные настройки */
        $this->smarty->assign('logs_file', $telegram->fetchLogData('telegram.log'));
        $this->smarty->assign('telegram', $telegram->data);


        if ($this->permissions('telegrams')) {
            return $this->smarty->fetch('views/telegrams/index.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }


    /**
     * Отправляет файл в виде HTTP-ответа для загрузки.
     */
    private function sendFileResponse(string $file, string $key): void
    {
        response()->make(file_get_contents($file, FILE_USE_INCLUDE_PATH, null), \Mnv\Http\Response::HTTP_OK, [
            'Pragma'                 => 'public',
            'Expires'                => '0',
            'Content-Description'    => 'File Transfer',
            'Content-Type'           => 'application/octet-stream',
            'Content-Disposition'    => 'attachment; filename="notifications_' . $key . '_error_' . date('Y-m-d_H-i-s') . '.log"',
            'Content-Transfer-Encoding' => 'binary',
        ])->send();

        exit();
    }

    /**
     * Отправляет JSON-ответ.
     */
    private function sendJsonResponse(array $response, int $status = \Mnv\Http\Response::HTTP_OK): void
    {
        response()->json($response, $status, [
            'Content-Type' => 'application/json;charset=UTF-8',
            'Charset'      => 'utf-8',
        ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();

        exit();
    }


    /**
     * Отправляет HTTP-ответ с сообщением об ошибке в формате JSON.
     *
     * @param int $status HTTP код статуса ошибки.
     * @param string $message Сообщение об ошибке.
     * @return void
     */
    private function sendErrorResponse(int $status, string $message): void
    {
        $response = [
            'status'  => $status,
            'message' => $message,
            'type'    => 'error',
        ];

        $this->sendJsonResponse($response, $status);
        exit;
    }

}