/* Call an ajax entity update */
const currentUrl = document.documentElement.getAttribute("data-url");
document.addEventListener('click', async function (e) {
    // изменение статуса
    if (e.target && e.target.closest('.ajax_action')) {

        const target = e.target;
        const id = parseInt(target.getAttribute('data-id'));
        const module = target.getAttribute("data-module");
        const action = target.getAttribute("data-action");

        try {
            const response = await fetch(`${currentUrl}/${module}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({action, id})
            });

            const result = await response.json();

            if (result.status === 200) {
                target.closest("tr").classList.toggle('table-warning');
                target.innerHTML = result.data === 'V'
                    ? '<i class="ph-eye me-2"></i> ' + lang['status']
                    : '<i class="ph-eye-slash me-2"></i> ' + lang['status'];
            }
            new Noty({text: result.message, type: result.type}).show();

        } catch (error) {
            console.error('Error:', error);
            new Noty({text: error.message || 'An error occurred', type: 'error'}).show();
        }
    }

    // одобрение без модерации
    if (e.target && e.target.closest('.ajax_approve')) {

        const target = e.target;
        const id = parseInt(target.getAttribute('data-id'));
        const module = target.getAttribute("data-module");
        const action = target.getAttribute("data-action");

        try {
            const response = await fetch(`${currentUrl}/${module}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({action, id})
            });

            const result = await response.json();

            if (result.status === 200) {
                if (module === 'users') {
                    target.remove();
                    const statusIndicator = document.querySelector(`#status_indicator_${id}`);
                    if (statusIndicator) {
                        statusIndicator.classList.replace('bg-danger', 'bg-success');
                    }
                } else {
                    target.classList.remove('ajax_approve', 'text-danger');
                    target.classList.add('ajax_action');
                    target.closest("tr").classList.remove('table-danger');
                    target.innerHTML = '<i class="ph-eye me-2"></i> ' + lang['status'];
                    target.setAttribute("data-action", "status");
                }
            }
            new Noty({text: result.message, type: result.type}).show();

        } catch (error) {
            console.error('Error:', error);
            new Noty({text: error.message || 'An error occurred', type: 'error'}).show();
        }
    }

    // добавление в избранное
    if (e.target && e.target.closest('.ajax_favorites')) {

        const target = e.target;
        const id = parseInt(target.getAttribute('data-id'));
        const module = target.getAttribute("data-module");
        const action = target.getAttribute("data-action");

        try {
            const response = await fetch(`${currentUrl}/${module}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({action, id})
            });

            const result = await response.json();

            if (result.status === 200) {
                const isSuccess = result.data === 1;
                target.closest("tr").classList.toggle('table-success', isSuccess);
                target.classList.toggle('text-success', isSuccess);
            }
            new Noty({text: result.message, type: result.type}).show();

        } catch (error) {
            console.error('Error:', error);
            new Noty({text: error.message || 'An error occurred', type: 'error'}).show();
        }
    }
});


// function auto_keywords() {
//     const adminUrl = document.querySelector('html').getAttribute("data-url")
//     tinyMCE.triggerSave();
//     let txt = document.getElementsByClassName('description')[0].value;
//     $.post(adminUrl + "/handlers/keywords.php", { content: txt }, function(data) {
//         console.log(data.keywords);
//         $('#keywords').tokenfield('setTokens', data.keywords);
//     });
//     return false;
// }


// TODO не забыть заметь imageId на id во все пуктах добавление контента

// добавление информации к картинке в галереи
function imageDetails(imageId, confirm, module) {
    const metaImage = document.querySelector(`#meta_image_${imageId}`);
    if (!metaImage) {
        console.error(`Элемент с ID #meta_image_${imageId} не найден.`);
        return;
    }

    // Получаем данные из metaImage
    const getTextContent = (selector) => metaImage.querySelector(selector)?.textContent || '';
    const imageData = {
        title: getTextContent('#im_title'),
        alias: getTextContent('#im_alias'),
        description: getTextContent('#im_description'),
        link: getTextContent('#im_link'),
        position: getTextContent('#im_position')
    };

    // Формируем HTML для prompt-окна
    const createInputGroup = (label, id, value, isTextarea = false) => `
        <div class="form-group mb-3">
            <label class="form-group-float-label is-visible">${label}</label>
            ${isTextarea
        ? `<textarea rows="3" cols="3" class="form-control" id="${id}">${value}</textarea>`
        : `<input type="text" class="form-control" id="${id}" value="${value}" />`
    }
        </div>`;

    const formHtml = `
        ${createInputGroup('Заголовок', 'image_title', imageData.title)}
        ${createInputGroup('Альтернативный заголовок', 'image_alias', imageData.alias)}
        ${createInputGroup('Описание', 'image_description', imageData.description, true)}
        ${createInputGroup('Ссылка', 'image_link', imageData.link)}
    `;

    // Вызов bootbox.prompt
    bootbox.prompt({
        title: confirm,
        message: formHtml,
        inputType: 'select',
        value: imageData.position,
        inputOptions: [
            { text: 'По умолчанию', value: 'default' },
            { text: 'Банер', value: 'banner' },
            { text: 'Галерея', value: 'gallery' },
            { text: 'Карусель', value: 'carousel' },
            { text: 'Коллекция', value: 'collection' },
            { text: 'Блок', value: 'block' },
            { text: 'Логотип', value: 'logo' },
        ],
        buttons: {
            cancel: { label: 'Отмена', className: 'btn-sm btn-light' },
            confirm: { label: 'Сохранить', className: 'btn-sm btn-primary' }
        },
        callback: function (result) {
            if (result === null) return; // Пользователь нажал "Отмена"

            // Сбор данных из формы
            const getInputValue = (id) => document.querySelector(`#${id}`)?.value || '';
            const updatedData = {
                imageId,
                'picture[title]': getInputValue('image_title'),
                'picture[alias]': getInputValue('image_alias'),
                'picture[description]': getInputValue('image_description'),
                'picture[link]': getInputValue('image_link'),
                'picture[position]': result
            };

            // Отправляем данные на сервер
            sendImageUpdateRequest(module, updatedData).then(response => {
                console.log(response.status);
                if (response.status === 200) {
                    updateImageAttributes(imageId, response);
                } else {
                    console.warn('Ошибка ответа сервера:', response);
                }
            }).catch(error => {
                console.error(`Ошибка при выполнении запроса: ${error.message}`);
            });
        }
    });
}

// Отправка запроса на сервер
function sendImageUpdateRequest(module, payload) {
    const formBody = new URLSearchParams(payload).toString();
    return fetch(`index.php?mod=${module}&action=editPictureInfo`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8'
        },
        body: formBody
    }).then(response => {
        if (!response.ok) {
            throw new Error(`Ошибка сети: ${response.status}`);
        }
        return response.json();
    });
}

// Обновление атрибутов на странице
function updateImageAttributes(imageId, data) {
    const metaImage = document.querySelector(`#meta_image_${imageId}`);
    if (!metaImage) return;

    const updateTextContent = (selector, value) => {
        const element = metaImage.querySelector(selector);
        if (element) element.textContent = value;
    };

    updateTextContent('#im_title', data.title);
    updateTextContent('#im_alias', data.alias);
    updateTextContent('#im_description', data.description);
    updateTextContent('#im_link', data.link);
    updateTextContent('#im_position', data.position);
}


function confirmLanguageChange(sbmButton) {
    // bootbox.confirm({
    //     message: lang['sureToChangeLang'] + ' "'+sbmButton.form.defaultLang.options[sbmButton.form.defaultLang.selectedIndex].label+'"?',
    //     callback: function(result) {
    //         console.log(result);
    //         if (result === true) {
    //             sbmButton.form.submit();
    //         }
    //     }
    // });

    if (window.confirm(lang['sureToChangeLang'] + ' "' + sbmButton.form.defaultLang.options[sbmButton.form.defaultLang.selectedIndex].label + '"?') == false) return false;
    sbmButton.form.submit();
}

function languageOptionChange(thisSelect) {
    document.getElementById('codename').value = thisSelect.value;
    document.getElementById('languageName').value = thisSelect.options[thisSelect.selectedIndex].text
    if (typeof lang2charset != 'undefined') {
        if (lang2charset[thisSelect.value]) {
            var charsetOptions = document.getElementById('charsetOptions').options;
            for (i = 0; i < charsetOptions.length; i++) {
                if (charsetOptions[i].value == lang2charset[thisSelect.value]) {
                    charsetOptions[i].selected = true;
                    break;
                }
            }

            // var adminLanguageOptions = document.getElementById('adminLanguageOptions').options;
            // for (i = 0; i < adminLanguageOptions.length; i++) {
            //     if (adminLanguageOptions[i].value == thisSelect.value) {
            //         adminLanguageOptions[i].selected = true;
            //         break;
            //     }
            // }
        }
    }
}

function deleteStats() {

    if (!ajaxIsFree())
        return false;

    var settingsForm = document.getElementById('settings');
    var date = settingsForm['date'].value;

    bootbox.confirm({
        closeButton: false,
        message: lang['sureToDeleteStats'] + ' ' + date + '?',
        callback: function (result) {
            console.log(result);
            if (result === true) {
                postData("index.php?mod=settings&action=delete_stats&date=" + date);
                deleteStatsMessage();
            }
        }
    });

    return false;
}

function clearCache() {
    if (!ajaxIsFree()) return false;
    postData("index.php?mod=settings&action=clear_cache");
    clearCacheMessage();

    return false;
}


// рабочее удаление id, заголовок, ссылка
function remove(id, title, module) {
    if (!ajaxIsFree()) return false;

    bootbox.confirm({
        closeButton: false,
        message: `${lang['sureToDelete']} "${title}"?`,
        callback: function (result) {
            if (result === true) {
                fetch(`index.php?mod=${module}&action=remove`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: JSON.stringify({ id: id })
                }).then(response => response.json()).then(response => {
                    if (response.status === 200) {
                        removeElement(id, module.slice(0, -1));
                    }
                    new Noty({ text: response.message, type: response.type }).show();
                }).catch(error => {
                    console.error('Error:', error);
                    new Noty({ text: 'An error occurred. Please try again later.', type: 'error' }).show();
                });
            }
        }
    });

    return false;
}


// remove preview - если предпоказ
function removePreviewImage() {
    // удалить кноку удаления
    const buttonRemove = document.getElementById('content-image-preview-remove');
    buttonRemove.parentNode.removeChild(buttonRemove);

    // удаляем картинку
    const preview = document.getElementById('content-image-preview');
    if (preview.hasChildNodes()) {
        preview.removeChild(preview.children[0]);
    }
    document.getElementById('content-image-preview-add').innerHTML = '<i class="ph-image me-2"></i>Загрузить файл';

    return false;

}
/**
 * Выполняет запрос на удаление файла и выполняет заданное действие на успех.
 * @param {number|string} row - Идентификатор строки для удаления.
 * @param {number|string} imageId - Идентификатор файла для удаления.
 * @param {string} module - Название модуля.
 * @param {Function} onSuccess - Коллбэк, выполняемый при успешном удалении файла.
 */
async function removeFile(row, imageId, module, onSuccess) {
    const formData = new FormData();
    formData.append('imageId', imageId);

    try {
        const response = await fetch(`/admin/${module}?action=deleteFile`, {
            method: 'POST',
            body: formData
        });

        if (!response.ok) {
            throw new Error('Network response was not ok');
        }

        const { status, message, type } = await response.json();

        // Если успешно — выполняем переданный коллбэк
        if (status === 200 && typeof onSuccess === 'function') {
            onSuccess(row);
        }

        // Показываем уведомление
        showNotification(message, type);
    } catch (error) {
        console.error('Error:', error);
        showNotification(`An error occurred while deleting the file: ${error.message}`, 'error');
    }
}

/**
 * Удаляет элемент из DOM по его ID.
 * @param {string} containerId - ID контейнера, в котором находится элемент.
 * @param {string|number} row - ID элемента, который нужно удалить.
 */
function removeRow(containerId, row) {
    const container = document.getElementById(containerId);

    if (!container) {
        console.error(`Контейнер с id "${containerId}" не найден`);
        return;
    }

    const elem = container.querySelector(`#item-${row}`);
    if (elem) {
        elem.remove(); // Используем более современный метод remove()
    } else {
        console.error(`Элемент с id "item-${row}" внутри #${containerId} не найден`);
    }
}

/**
 * Удаляет изображение из галереи.
 * @param {number|string} row - ID изображения.
 * @param {number|string} imageId - ID изображения для удаления.
 * @param {string} module - Название модуля.
 */
function removeImage(row, imageId, module) {
    removeFile(row, imageId, module, (row) => {
        removeRow('imageList', row);
    });
}

/**
 * Удаляет документ из галереи документов.
 * @param {number|string} row - ID элемента.
 * @param {number|string} imageId - ID документа для удаления.
 * @param {string} module - Название модуля.
 */
function removeDocs(row, imageId, module) {
    removeFile(row, imageId, module, (row) => {
        removeRow('fileList', row);
    });
}

// Работа с галереей

 /**
 * Выполняет асинхронный запрос.
 * @param {string} url - URL для выполнения запроса.
 * @param {string} method - HTTP метод (GET, POST и т.д.).
 * @param {Object} [body=null] - Тело запроса, если нужно.
 * @returns {Promise<Object>} - Ответ от сервера в формате JSON.
 * @throws {Error} - Ошибка при выполнении запроса.
 */
async function sendRequest(url, method = 'GET', body = null) {
    try {
        const options = {
            method,
            headers: {
                'Content-Type': 'application/json',
            },
            ...(body && { body: JSON.stringify(body) }), // Если есть тело запроса, добавляем его.
        };

        const response = await fetch(url, options);
        if (!response.ok) {
            throw new Error(`HTTP Error: ${response.status}`);
        }

        return await response.json();
    } catch (error) {
        console.error(`Ошибка выполнения запроса: ${error.message}`);
        throw error;
    }
}



/**
 * Скрывает блок - группу кнопок для применения сотрировки.
 * @param {string} selector - Селектор блока для применения сотрировки.
 */
function hideSortingPanel(selector = '.sortable_footer_navbar') {
    const element = document.querySelector(selector);
    if (element) {
        element.classList.remove('show');
    } else {
        console.warn(`Элемент с селектором "${selector}" не найден.`);
    }
}

/**
 * Перезагружает список галереи.
 * Используем переинициализацию блока галереи для обновления.
 */
function reloadGallery() {
    const imageList = document.querySelector('#imageList');
    if (imageList) {
        fetch(location.href).then(response => {
            if (!response.ok) {
                throw new Error(`Ошибка загрузки: ${response.status}`);
            }
            return response.text();
        }).then(html => {
            const parser = new DOMParser();
            const doc = parser.parseFromString(html, "text/html");
            const newContent = doc.querySelectorAll("figure.gallery-item");

            if (newContent.length > 0) {
                imageList.innerHTML = ""; // Очистка содержимого
                // Добавляем каждый элемент с короткой задержкой
                newContent.forEach((item, index) => {
                    const clone = item.cloneNode(true);

                    // Скрываем элемент перед добавлением для анимации
                    clone.style.opacity = "0";
                    clone.style.transform = "translateY(20px)";
                    imageList.appendChild(clone);

                    // Устанавливаем задержку перед отображением
                    setTimeout(() => {
                        clone.style.transition = "opacity 0.5s ease, transform 0.5s ease";
                        clone.style.opacity = "1";
                        clone.style.transform = "translateY(0)";
                    }, 100 * index); // Увеличиваем задержку для поочередности
                });
            } else {
                console.warn("Новый контент не найден.");
            }
        }).catch(error => {
            console.error(`Ошибка при обновлении галереи: ${error.message}`);
        });
    }
}

/**
 * Сбор идентификаторов элементов из DOM.
 * @param {string} selector - Селектор элемента.
 * @returns {string[]} - Массив идентификаторов.
 */
function collectElementIds(selector = '#imageList figure.gallery-item') {
    return Array.from(document.querySelectorAll(selector))
        .map(item => item.getAttribute('data-id'))
        .filter(Boolean); // Берем только валидные значения.
}

/**
 * Выполняет действие для сортировки галереи (сохранение или сброс).
 * @param {string} url - URL для выполнения запроса.
 * @param {boolean} reset - Флаг, указывает, выполнять ли сброс (true) или отправку данных (false).
 */
async function handleGalleryAction(url, reset = false) {
    if (reset) {
        hideSortingPanel();
        reloadGallery();
        showNotification('Сортировка отменена', 'info');
        return;
    }

    const ids = collectElementIds();

    try {
        const response = await sendRequest(url, 'POST', { imageIds: ids });
        if (response && response.message && response.type) {
            showNotification(response.message, response.type);
        }
        hideSortingPanel();
        reloadGallery();
    } catch (error) {
        showNotification('Ошибка при сохранении сортировки', 'error');
    }
}
// end галерея

/**
 * Обрабатывает всплывающее уведомление.
 * @param {string} message - Текст уведомления.
 * @param {string} type - Тип уведомления (success, error, info, и т.д.).
 */
function showNotification(message, type = 'info') {
    new Noty({ text: message, type: type }).show();
}


function deleteImage(imageId, module) {
    if (!ajaxIsFree()) return false;
    bootbox.confirm({
        closeButton: false,
        message: lang['sureToDeleteImage'] + '?',
        callback: function (result) {
            if (result === true) {
                $.post('index.php?mod=' + module + "&action=deleteFile", { imageId: imageId,}, function (response) {
                    if (response.status === 200) {
                        removePreviewImage()
                    }
                    new Noty({text: response.message, type: response.type}).show();
                }, 'json');
            }
        }
    });
    return false;
}

function deleteFile(path, file, module) {
    bootbox.confirm({
        closeButton: false,
        message: lang['sureToDelete'] + ' "' + file + '"?',
        callback: function (res) {
            if (res === true) {
                document.location = 'index.php?mod=' + module + '&path=' + path + '&action=remove&file[name]=' + file;
            }
        }
    });
    return false;
}


// сортировка таблицы
async function tableSort(element, module) {
    if (!ajaxIsFree()) return false;

    let sortBy = element.getAttribute('data-sort-by')
    let sortOrder = element.getAttribute('data-sort-order')
    const response = await sendRequest("index.php?mod=" + module + "&action=sort_table", 'POST', {
        sortBy: sortBy,
        sortOrder: sortOrder
    });
    if (response) {
        window.location.reload();
    }
}

// очистка сортировка таблицы
async function clearTableSort(element, module) {

    if (!ajaxIsFree()) return false;
    const response = await sendRequest("index.php?mod=" + module + "&action=sort_table", 'POST');
    if (response) {
        window.location.reload();
    }
}

function removeElement(elementId, elementPrefix) {
    let node = document.getElementById(elementPrefix + '-' + elementId);
    node.parentNode.removeChild(node);
}

function proposeFileName(srcName, destName, formName, separator, convertToLowerCase) {
    let form = document.getElementById(formName);
    if (form[destName].value == '') {
        let re = new RegExp('(^\\' + separator + '|\\' + separator + '$)', 'gi');
        form[destName].value = form[srcName].value.replace(/[^0-9a-zA-Z\-_\.]+/gi, separator).replace(re, '');
        if (convertToLowerCase == '1') form[destName].value = form[destName].value.toLowerCase();
    }
}

function ajaxIsFree() {
    if (typeof waitingResponse != 'undefined' && waitingResponse == true) {
        bootbox.alert(lang['processingRequest']);
        return false;
    }
    return true;
}

function handleHttpResponse() {
    if (XMLHttp.readyState === 4) {
        if (XMLHttp.status === 200) {
            try {
                eval(XMLHttp.responseText);
            } catch (e) {
                if (typeof httpResponseEvalOnError != 'undefined' && httpResponseEvalOnError != '') {
                    httpResponseText = XMLHttp.responseText;
                    eval(httpResponseEvalOnError);
                } else {
                    bootbox.alert(lang['operationError'] + ": " + XMLHttp.responseText);
                    document.location = document.location.pathname;
                }
            }
            waitingResponse = false;
        } else {
            bootbox.alert(lang['operationError'] + ": " + XMLHttp.responseText);
            document.location = document.location.pathname;
        }
    }
}

function postData(destination, data) {
    if (window.XMLHttpRequest) {
        XMLHttp = new XMLHttpRequest();
    } else if (window.ActiveXObject) {
        XMLHttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    method = 'POST';
    if (typeof data == 'undefined') method = 'GET';
    XMLHttp.open(method, destination, true);
    if (method === 'POST') XMLHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
    XMLHttp.onreadystatechange = handleHttpResponse;
    XMLHttp.send(data);
    waitingResponse = true;
}

// Autocomplete */
(function ($) {
    $.fn.autocomplete = function (option) {
        return this.each(function () {
            var $this = $(this);
            var $dropdown = $('<ul class="dropdown-menu" />');

            this.timer = null;
            this.items = [];

            $.extend(this, option);

            $this.attr('autocomplete', 'off');
            // Focus
            $this.on('focus', function () {
                this.request();
            });
            // Blur
            $this.on('blur', function () {
                setTimeout(function (object) {
                    object.hide();
                }, 200, this);
            });
            // Keydown
            $this.on('keydown', function (event) {
                switch (event.keyCode) {
                    case 27: // escape
                        this.hide();
                        break;
                    default:
                        this.request();
                        break;
                }
            });

            // Click
            this.click = function (event) {
                event.preventDefault();

                var value = $(event.target).parent().attr('data-value');
                if (value && this.items[value]) {
                    this.select(this.items[value]);
                }
            }

            // Show
            this.show = function () {
                var pos = $this.position();
                $dropdown.css({
                    top: pos.top + $this.outerHeight(),
                    left: pos.left
                });
                $dropdown.show();
            }

            // Hide
            this.hide = function () {
                $dropdown.hide();
            }

            // Request
            this.request = function () {
                clearTimeout(this.timer);

                this.timer = setTimeout(function (object) {
                    object.source($(object).val(), $.proxy(object.response, object));
                }, 200, this);
            }

            // Response
            this.response = function (json) {

                console.log(json);

                var html = '';
                var category = {};
                var name;
                var i = 0, j = 0;

                if (json.length) {
                    for (i = 0; i < json.length; i++) {
                        // update element items
                        this.items[json[i]['value']] = json[i];

                        if (!json[i]['category']) {
                            // ungrouped items
                            html += '<li data-value="' + json[i]['value'] + '"><a class="dropdown-item" href="#">' + json[i]['label'] + '</a></li>';
                        } else {
                            // grouped items
                            name = json[i]['category'];
                            if (!category[name]) {
                                category[name] = [];
                            }

                            category[name].push(json[i]);
                        }
                    }

                    for (name in category) {
                        html += '<li class="dropdown-header">' + name + '</li>';

                        for (j = 0; j < category[name].length; j++) {
                            if (category[name][j]['image'] == undefined || category[name][j]['image'] == null) {
                                html += '<li data-value="' + category[name][j]['value'] + '"><a class="dropdown-item" href="#">&nbsp;&nbsp;&nbsp;' + category[name][j]['label'] + '</a></li>';
                            } else {
                                html += '<li data-value="' + category[name][j]['value'] + '"><a class="dropdown-item" href="#"><span class="input-group-text"><img src="' + category[name][j]['image'] + '" width="30"/></span>' + category[name][j]['label'] + '</a></li>';
                            }
                        }
                    }
                }

                if (html) {
                    this.show();
                } else {
                    this.hide();
                }

                $dropdown.html(html);
            }

            $dropdown.on('click', '> li > a', $.proxy(this.click, this));
            $this.after($dropdown);
        });
    }
})(window.jQuery);




