<?php


require_once '../includes/overall.inc.php';
require_once '../includes/admin-functions.inc.php';

use Mnv\Core\Helpers;
use Mnv\Core\UserInfo;
use Mnv\Core\ConfigManager;
use Mnv\Admin\Controllers\IndexAdmin;
use Mnv\Core\Utilities\Cookie\Cookie;
use Mnv\Core\Utilities\Cookie\Session;

const MNV_CMS = true;

$time_start = microtime(true);

/* header no proxy / browser cache */
$expires = time() + (60*60*24);
header("Pragma: no-cache");
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");

$adminSessionName   = 'ls-admin';
$smarty->assign('adminSessionName', $adminSessionName);

Session::start($adminSessionName);
$smarty->assign('sessionId', Session::id());
Cookie::setcookie($adminSessionName, Session::id(),time () + 3600, '/', '', '', true, 'Lax');

try {
    $admin = new IndexAdmin($smarty);

    /** проверка запрещенных IP-адресов */
    $config = include '../includes/config.auth.inc.php';
    if ($config['blockHacking']) {
        $result = Helpers::dieIfBanned(UserInfo::get_ip());
        if ($result) {
            $smarty->assign('isBanned', $result);
        }
    }

    print $admin->fetch();
} catch (Exception $e) {
//    echo "Error: " . $e->getMessage() . "\r\n";
    print "<!--\r\n";
    print "Error: " . $e->getMessage() . "\r\n";
    print "-->";
}

//unset($_SESSION['admin']);
//unset($_SESSION["csrf__token"]);
//print_r($_SESSION);
//print_r($_COOKIE);

// Отладочная информация
print "<!--\r\n";
$time_end = microtime(true);
$exec_time = $time_end-$time_start;
if(function_exists('memory_get_peak_usage')) {
    print "memory peak usage: ".memory_get_peak_usage()." bytes (" . (memory_get_peak_usage(true)/1024/1024)." MiB) \r\n";
    print "Memory in use: " . memory_get_usage() . " (". (sprintf("%0.2f",(memory_get_usage() / 1024) / 1024)) ."M) \r\n";
}
print "page generation time: " . $exec_time . " seconds\r\n";
print "php run time: ". round($exec_time, 4) . " seconds\r\n";
print "Query count: ".     connect()->queryCount() . "\r\n";
print "-->";

