<script src="/admin/assets/editor/tinymce5/tinymce.min.js"></script>
{strip}
<script>
	{literal}
    $(function(){

	    tinymce.baseURL = '/admin/assets/editor/tinymce5';
	    tinymce.suffix = '.min';
        tinymce.init({
            selector: 'textarea.description',
            language : "{/literal}{$config.admin_language}{literal}",
            element_format : 'html',
            theme: 'silver',
            skin:  'oxide',
            width : "100%",
            height : 400,
            deprecation_warnings: false,
            plugins: ["fullscreen advlist autolink lists link image charmap anchor searchreplace visualblocks visualchars nonbreaking noneditable table paste codemirror spellchecker mnvbutton codesample hr quickbars autosave wordcount pagebreak"],

            setup: function(editor) {
                editor.on('PreInit', function() {
	                const schema = editor.schema;
	                const shortEndedElements = schema.getShortEndedElements();
	                shortEndedElements['path'] = {};
	                shortEndedElements['source'] = {};
	                shortEndedElements['use'] = {};
                });
            },

            relative_urls : false,
            convert_urls : false,
            remove_script_host : false,
            verify_html: false,
            nonbreaking_force_tab: true,
            branding: false,
            default_link_target: '_blank',
            browser_spellcheck: true,
            pagebreak_separator: '{PAGEBREAK}',
            pagebreak_split_block: true,
            noneditable_editable_class: 'contenteditable',
            noneditable_noneditable_class: 'noncontenteditable',
            contextmenu: 'image imagetools table spellchecker lists',

            image_advtab: true,
            image_caption: true,
            paste_data_images: true,
            automatic_uploads: true,
	        images_reuse_filename: true,
	        image_uploadtab: false,
	        images_file_types: 'gif,jpg,png,jpeg,bmp,webp',
            images_upload_handler: function mnv_image_upload_handler(blobInfo, success, failure, progress) {
	            const formData = new FormData();
	            const xhr = new XMLHttpRequest();
	            const editor = tinymce.activeEditor;

	            xhr.withCredentials = false;
	            xhr.open('POST', "{/literal}{$GLOBAL_URL}{literal}/admin/handlers/upload-file.php");
	            xhr.setRequestHeader("X-Requested-With", "XMLHttpRequest");

	            xhr.upload.onprogress = function(e) {
		            progress(e.loaded / e.total * 100);
	            };

	            xhr.onload = function() {
		            if (xhr.status >= 500) {
			            failure('HTTP Error: ' + xhr.status, { remove: true });
			            return;
		            }

		            if (xhr.status < 200 || xhr.status >= 300) {
			            failure('HTTP Error: ' + xhr.status);
			            return;
		            }

		            let file;
		            try {
			            file = JSON.parse(xhr.responseText);
		            } catch (error) {
			            failure('Invalid JSON: ' + xhr.responseText);
			            return;
		            }

		            if (!file || typeof file.url !== 'string') {
			            const errorMessage = typeof file.error === 'string' ? file.message : 'Invalid JSON: ' + xhr.responseText;
			            failure(errorMessage);

			            const node = editor.selection.getEnd();
			            editor.selection.select(node);
			            editor.selection.setContent('');
			            return;
		            }

		            if (file.link) {
			            console.log("json.link => " + file.link)
			            editor.selection.select(editor.selection.getEnd());
			            editor.selection.setContent(`<a href="${file.link}" class="highslide"><img src="${file.url}" style="display: block; margin-left: auto; margin-right: auto;"></a>&nbsp;`);
			            editor.notificationManager.close();
		            } else {
			            console.log("json.url => " + file.url)
			            success(file.url);
		            }
	            };

	            xhr.onerror = function() {
		            failure('Image upload failed due to a XHR Transport error. Code: ' + xhr.status);
	            };

	            formData.append('file', blobInfo.blob(), blobInfo.filename());
	            formData.append("action", "upload");
	            formData.append("path", "content");
	            xhr.send(formData);
            },

            file_picker_types: 'image',
            file_picker_callback: function (cb, value, meta) {
	            const input = document.createElement('input');
	            input.type = 'file';
	            input.accept = 'image/*';

                input.onchange = function () {
	                const file = input.files[0];
	                if (!file) return;

                    const reader = new FileReader();
	                reader.onload = function () {
		                const blobCache = tinymce.activeEditor.editorUpload.blobCache;
		                const blobInfo = blobCache.create(file.name, file, reader.result.split(',')[1]);
		                blobCache.add(blobInfo);

		                // Вызовите обратный вызов и передайте URL-адрес загруженного изображения в TinyMCE
		                cb(blobInfo.blobUri(), { title: file.name });
	                };

                    reader.readAsDataURL(file);
                };

                input.click();
            },

            draggable_modal: true,
            menubar: 'edit insert format table view tools',
            toolbar: 'bold italic underline strikethrough | align | bullist numlist | indent outdent | link unlink | image mnvupload mnvvideo mnvaudio mnvtube | mnv | fontformatting textformatting code removeformat',
            toolbar_mode: 'floating',
            toolbar_groups: {

                fontformatting: {
                    icon: 'change-case',
                    tooltip: 'Formatting',
                    items: 'formatselect fontselect fontsizeselect | forecolor backcolor'
                },

                textformatting: {
                    icon: 'edit-block',
                    tooltip: 'Tools',
                    items: 'searchreplace spellchecker | mnvtypo removeformat'
                },

                align: {
                    icon: 'align-center',
                    tooltip: 'Formatting',
                    items: 'alignleft aligncenter alignright alignjustify'
                },

                mnv: {
                    icon: 'preview',
                    tooltip: 'MNV Tags',
                    items: 'mnvquote codesample | pagebreak'
                }
            },

            menu: {
                view: {
					title: 'View',
                    items: 'restoredraft | visualaid visualchars visualblocks'
				}
            },
            removed_menuitems: 'codeformat, bold, italic, underline, strikethrough',

            quickbars_insert_toolbar: '',
            quickbars_selection_toolbar: 'bold italic underline | quicklink mnvquote mnvspoiler mnvhide | forecolor backcolor formatselect',

            autosave_ask_before_unload: true,
            autosave_interval: '10s',
            autosave_prefix: 'mnv-editor',
            autosave_restore_when_empty: false,
            autosave_retention: '10m',


            // forced_root_block: 'p', // Текст оборачивается в <p>
            forced_root_block : false,
            paste_as_text: true, // Если требуется, чтобы вставлялся только текст
            paste_preprocess: function(plugin, args) {
                args.content = '<p>' + args.content + '</p>';
            },
            formats: {
                bold: { inline: 'b' },
                italic: { inline: 'i' },
                underline: { inline: 'u', exact : true },
                strikethrough: { inline: 's', exact : true }
            },

            spellchecker_language : "{/literal}{$config.admin_language}{literal}",
            spellchecker_languages : "Russian=ru,English=en",
            spellchecker_rpc_url : "https://speller.yandex.net/services/tinyspell",

            mnv_root : "",
            mnv_upload_area : "description",
            mnv_upload_user : "admin",
            mnv_upload_news : "0",
        });

    });

    {/literal}
</script>
{/strip}