<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/contenttype?action=edit{if isset($typeId)}&id={$typeId}{/if}"}

    {capture name="breadcrumb"}
	    <a href="{$adminUrl}/contenttypes" class="breadcrumb-item">Тип контента</a>
		<a href="{$adminUrl}/contenttype?action=edit{if isset($typeId)}&id={$typeId}{/if}" class="breadcrumb-item">{$title|default:''}</a>
{*		<span class="breadcrumb-item active">{general:add}</span>*}
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">

		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap p-0">
						<ul class="nav nav-tabs nav-tabs-overline border-top-0">
							<li class="nav-item">
								<a href="#general" class="nav-link active show" data-bs-toggle="tab" id="tab_general">{general:card:general}</a>
							</li>

							<li class="nav-item collapse {if isset($field.type) && ($field.type eq 'R' || $field.type eq 'S')}show{/if}" id="tab_variants">
								<a href="#tabProperties" class="nav-link" data-bs-toggle="tab">Варианты</a>
							</li>
						</ul>
					</div>
					<div class="card-body">
						<div class="tab-content border-top-0 rounded-top-0 mb-0">

							<div class="tab-pane fade show active" id="general">
								<div class="row mb-3">
									<label class="col-lg-3 col-form-label {if isset($errors.name)}text-danger{/if}">Название поля:</label>
									<div class="col-lg-9">
										<input type="text" class="form-control" id="name" autocomplete="off" name="field[name]" value="{if isset($field.name)}{$field.name}{/if}">
									</div>
								</div>
								<div class="row mb-3">
									<label class="col-lg-3 col-form-label {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameCharacters)}text-danger{/if}">Ключ поля:</label>
									<div class="col-lg-9">
										<input type="text" class="form-control" id="fileName" autocomplete="off" name="field[fileName]" value="{if isset($field.fileName)}{$field.fileName}{/if}">
										<div class="form-control form-control-plaintext fs-sm text-danger">
											<p>Последовательность символов, используемая в качестве идентификатора. Вы можете использовать цифры от 0 до 9, символы английского алфавита и знак "_".</p>
										</div>
									</div>
								</div>
								<div class="row mb-3">
									<label class="col-lg-3 col-form-label">Тип:</label>
									<div class="col-lg-9">
										{* field status *}
										{include file="components/fields/select.tpl" col="col-md-4" id="typeFields" title="" field="field[type]" array=$typeFields selected=$field.type|default:'' class="form-group" width='300'}
										{* /field status *}
									</div>
								</div>
								<div class="row mb-3 radio_group_position collapse {if isset($field.type) && $field.type eq 'R'}show{/if}">
									<label class="col-lg-3 col-form-label">Расположение радиогруппы:</label>
									<div class="col-lg-9">
                                        {include file="components/fields/select.tpl" col="col-md-4" id="radio_group_position" title="" field="field[radio_group_position]" array=$radioGroupPositions selected=$field.radio_group_position|default:'' class="form-group" width='300'}
									</div>
								</div>

								<div class="row mb-3 radio_group_sql collapse {if isset($field.type) && ($field.type eq 'R' || $field.type eq 'S' || $field.type eq 'C')}show{/if}">
									<label class="col-lg-3 col-form-label">Определение столбца MySQL: <br> MySQL запрос создется один раз при создаение поля</label>
									<div class="col-lg-9">
										<input type="text" class="form-control" id="type_sql" autocomplete="off" name="field[type_sql]" value="{$field.type_sql|default:''}">
										<div class="form-text">
											<code>VARCHAR( 255 ) NULL</code><br>
											<code>CHAR( 1 ) NOT NULL DEFAULT 0 </code><br>
											<code>CHAR( 1 ) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'H' </code><br>
											<code>tinyint(1) NOT NULL DEFAULT '0'</code><br>
										</div>
									</div>
								</div>


								<div class="row mb-3">
									<label class="col-lg-3 col-form-label {if isset($errors.typeId)}text-danger{/if}">Тип контента:</label>
									<div class="col-lg-9">
										{* field status *}
										{include file="components/fields/select.tpl" col="col-md-4" id="selectContentTypes" title="" field="field[typeId]" array=$selectContentTypes
		                                    selected="{if isset($typeId) && $typeId > 0}{$typeId}{else}{$field.typeId|default:''}{/if}" class="form-group" width='300'}
										{* /field status *}
									</div>
								</div>


								<div class="row mb-3">
									<label class="col-lg-3 col-form-label">Пользовательский CSS-класс:</label>
									<div class="col-lg-9">
										<input type="text" class="form-control" id="css" autocomplete="off" name="field[class]" value="{if isset($field.class)}{$field.class}{/if}">
									</div>
								</div>
								<div class="row mb-3">
									<label class="col-lg-3 col-form-label">Пользовательский CSS-класс оболочки:</label>
									<div class="col-lg-9">
										<input type="text" class="form-control" id="css" autocomplete="off" name="field[wrapper_class]" value="{if isset($field.wrapper_class)}{$field.wrapper_class}{/if}">
									</div>
								</div>
								<div class="row mb-3">
									<label class="col-lg-3 col-form-label">{general:status}:</label>
									<div class="col-lg-9">
	                                    {* field status *}
	                                    {include file="components/fields/select.tpl" col="col-md-4" id="status" title="" field="field[status]" array=$statuses selected=$field.status|default:'V' class="form-group" width='300'}
	                                    {* /field status *}
									</div>
								</div>
								<div class="row mb-3">
									<label class="col-lg-3 col-form-label">Раположение:</label>
									<div class="col-lg-9">
                                        {* field position *}
                                        {include file="components/fields/select.tpl" col="col-md-4" id="position" title="" field="field[position]" array=$positions selected=$field.position|default:'M' class="form-group" width='300'}
                                        {* /field position *}
									</div>
								</div>
							</div>

							<div class="tab-pane fade collapse{if isset($field.type) && ($field.type eq 'R' || $field.type eq 'S' || $field.type eq 'M')}show{/if}" id="tabProperties">
								<table class="table table-xs table-togglable table-striped table-hover" id="properties">
									<thead>
										<tr>
											<th class="text-center text-muted" width="100"><i class="icon-checkmark3"></i></th>
											<th width="200">Ключ</th>
											<th>Значение</th>
										</tr>
									</thead>
									<tbody class="selectable-demo-list">
										{assign var=property_row value=0}
										{if !empty($properties)}
											{foreach $properties as $property}
												<tr class="" id="property_row-{$property_row}">
													<td class="text-center">
														<input type="hidden" class="form-control" name="properties[{$property_row}][propertyId]" value="{$property.propertyId}">
														<button type="button" class="btn btn-link text-danger" onclick="confirm('Данное действие необратимо. Вы уверены?') ? $('#property_row-{$property_row}').remove() : false;"><i class="ph-trash"></i></button>
													</td>
													<td class="text-start"><input type="text" class="form-control" name="properties[{$property_row}][propertyKey]" value="{$property.propertyKey}"></td>
													<td class="text-start"><input type="text" class="form-control" name="properties[{$property_row}][name]" value="{$property.name}"></td>

												</tr>
												{assign var=property_row value=$property_row+1}
											{/foreach}
										{/if}
									</tbody>
								</table>
								<div class="card-footer text-right">
									<button type="button" class="btn btn-outline-primary" onclick="addProperty();">Добавить вариант</button>
								</div>
							</div>

						</div>
					</div>


				</div>
			</div>

			<div class="col-md-12 text-center">
                {if isset($field.fieldId)}<input type="hidden" class="form-control" id="id" name="id" value="{$field.fieldId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>
	</div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

<script>

    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: 'Новое поле "{$field.name|default:''}" сохранено', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.name)} new Noty({ text: 'Введите название поля', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Новое поле "{$field.name|default:''}" не сохранено', type: 'error', timeout: 2500 }).show(); {/if}

        {if isset($errors.fileName)} new Noty({ text: 'Введите ключ поля на анг. языке', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameExists)} new Noty({ text: 'Ключ с этим названием уже сужествует', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameCharacters)} new Noty({ text: 'Ключ может содержать только следующие символы: A-Z a-z _', type: 'error', timeout: 2500 }).show(); {/if}

        {if isset($errors.typeId)} new Noty({ text: 'Выберите тип контента', type: 'error', timeout: 2500 }).show(); {/if}
    });


    $(document).on('change', '#typeFields', function() {
		const value = $(this).val();

        console.log(value)
		const tabVariants = document.getElementById('tab_variants');
		const radioGroupSql = document.querySelector('.radio_group_sql');
		const typeSql = document.querySelector('#type_sql');
		const radioGroupPosition = document.querySelector('.radio_group_position');

		typeSql.value = '';
		// Проверка, если элемент найден
		if (tabVariants && radioGroupSql && typeSql && radioGroupPosition) {
			// Словарь значений для typeSql
			const typeSqlValues = {
				'S': "CHAR( 1 ) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'H'",
				'R': "CHAR( 1 ) NOT NULL DEFAULT 0",
				'C': "tinyint(1) NOT NULL DEFAULT '0'"
			};

			// Проверяем, если value одно из списка
			if (typeSqlValues.hasOwnProperty(value)) {
				typeSql.value = typeSqlValues[value]; // Устанавливаем значение для typeSql

				// Обрабатываем видимость tabVariants
				if (value === 'C') {
					tabVariants.classList.remove('show'); // Скрываем tabVariants для 'C'
				} else {
					tabVariants.classList.add('show');  // Показываем tabVariants для 'R' и 'S'
				}

				radioGroupSql.classList.add('show');   // Всегда показываем radioGroupSql для 'R', 'S' и 'C'
			} else {
				// Если значение не подходит, скрываем элементы
				tabVariants.classList.remove('show');
				radioGroupSql.classList.remove('show');
			}

			// Показываем radioGroupPosition только для 'R'
			radioGroupPosition.classList.toggle('show', value === 'R');
		} else {
			console.error("Один или несколько элементов не найдены в DOM.");
		}
    })


	let property_row = {$property_row};
	dragula(Array.from(document.querySelectorAll('.sortable_options')), {
		direction: 'vertical',
		slideFactorY: 100,
		mirrorContainer: document.querySelector('.sortable_options')
	});

	function addProperty() {
		let html  = '<tr id="property_row-' + property_row + '">';
		html += '	<td class="text-center">';
		html += '		<input type="hidden" class="form-control" name="properties[' + property_row + '][propertyId]" value="">';
		html += '		<button type="button" class="btn btn-link text-danger" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#property_row-' + property_row + '\').remove() : false;"><i class="ph-trash"></i></button>';
		html += '	</td>';
		html += '	<td class="text-start"><input type="text" class="form-control" name="properties[' + property_row + '][propertyKey]" placeholder="Введите ключ"></td>';
		html += '	<td class="text-start"><input type="text" class="form-control" name="properties[' + property_row + '][name]"  placeholder="Введите значение"></td>';
		html += '</tr>';

		$('#properties tbody').append(html);

		property_row++;
	}


</script>