<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/contenttypes"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/contenttypes" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
        {*			<span class="breadcrumb-item active">{general:add}</span>*}
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">

		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-4">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.name)}text-danger{/if}">{general:title}</label>
										<input type="text" class="form-control" id="name" autocomplete="off" name="type[name]" value="{$type.name|default:''}">
									</div>
								</div>
								<div class="col-md-4">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">URL (только буквы)</label>
										<input type="text" class="form-control" id="fileName" name="type[fileName]" value="{$type.fileName|default:''}">
									</div>
								</div>

                                {* field status *}
                                {include file="components/fields/select.tpl" col="col-md-4" id="status" title="{general:status}" field="type[status]" array=$statuses selected=$type.status|default:'V' class="form-group mb-3"}
                                {* /field status *}

								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label">Группа пользователей</label>
                                        {html_options options=$groups name="groupIds[]" id="groups" selected=$type.privilege|default:'' class="form-control select" data-width="100%" multiple=""}
									</div>
								</div>

								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label">Модули</label>

										<div class="form-check mb-2">
											<input type="checkbox" class="form-check-input" id="moduleImage" name="modules[image]"  value="1" {if isset( $type.modules.image) and  $type.modules.image eq 1}checked{/if}>
											<label class="form-check-label" for="moduleImage">Основное изображение</label>
										</div>
										<div class="form-check mb-2">
											<input type="checkbox" class="form-check-input" id="moduleGallery" name="modules[gallery]" value="1" {if isset( $type.modules.gallery) and  $type.modules.gallery eq 1}checked{/if}>
											<label class="form-check-label" for="moduleGallery">Фотогалерея</label>
										</div>
										<div class="form-check mb-2">
											<input type="checkbox" class="form-check-input" id="moduleDocument" name="modules[document]" value="1" {if isset( $type.modules.document) and  $type.modules.document eq 1}checked{/if}>
											<label class="form-check-label" for="moduleDocument">Файлы</label>
										</div>
										<div class="form-check mb-2">
											<input type="checkbox" class="form-check-input" id="moduleSeo" name="modules[seo]" value="1" {if isset( $type.modules.seo) and  $type.modules.seo eq 1}checked{/if}>
											<label class="form-check-label" for="moduleSeo">Seo</label>
										</div>
										<div class="form-check mb-2">
											<input type="checkbox" class="form-check-input" id="publishEnd" name="modules[publishEnd]" value="1" {if isset( $type.modules.publishEnd) and  $type.modules.publishEnd eq 1}checked{/if}>
											<label class="form-check-label" for="publishEnd">Дата окончания публикации</label>
										</div>
									</div>
								</div>

							</div>
						</div>
					</div>
				</div>

				{* поля *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">Поля</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0  p-0">
							<table class="table table-xs table-togglable table-striped table-hover" id="fields">
								<thead>
								<tr>
									<th class="text-center" width="30">#</th>
									<th>Название поля</th>
									<th>Код поля</th>
									<th data-toggle="true">Тип поля</th>
									<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
								</tr>
								</thead>
                                {if !empty($fields)}
									<tbody class="sortable">
                                    {foreach from=$fields item=field}
										<tr id="field-{$field.fieldId}" data-id="{$field.fieldId}" {if $field.status eq 'H'}class="table-warning"{/if}>
											<td class="text-center text-nowrap"><i class="ph-dots-six text-muted"></i></td>
											<td class="text-start"> {$field.name nofilter}</td>
											<td class="text-start"> {$field.fileName nofilter}</td>
											<td class="text-start"> {$field.typeName nofilter}</td>
											<td class="text-center">
												<div class="d-inline-flex">
													<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="top" href="{$adminUrl}/field?action=edit{if isset($type.typeId)}&typeId={$type.typeId}{/if}&id={$field.fieldId}"><i class="ph-note-pencil me-2"></i></a>

													<div class="list-icons-item dropdown">
														<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

														<div class="dropdown-menu dropdown-menu-right">
															<a class="dropdown-item" href="{$adminUrl}/field?action=edit{if isset($type.typeId)}&typeId={$type.typeId}{/if}&id={$field.fieldId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
															{include file="components/actions/dropdown-status.tpl" module="field" id=$field.fieldId status=$field.status scope=parent}
															<div class="dropdown-divider"></div>
															<button type="button" class="dropdown-item text-danger" onclick="removeField({$field.fieldId}, '{$field.name}');"><i class="ph-trash me-2"></i> {general:delete}</button>
														</div>
													</div>
												</div>
											</td>
										</tr>
                                    {/foreach}

									</tbody>
                                {else}
									<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                                {/if}
							</table>
						</div>
						<div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
							<a class="btn btn-sm btn-primary" href="{$adminUrl}/field?action=add{if isset($type.typeId)}&typeId={$type.typeId}{/if}"><i class="ph-plus me-2"></i>{general:add} поле</a>
						</div>
					</div>
				</div>
                {* /поля *}
			</div>

			<div class="col-md-12 text-center">
                {if isset($type.typeId)}<input type="hidden" class="form-control" id="id" name="id" value="{$type.typeId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>
	</div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

<script>

    function notFound()
    {
        new Noty({ text: '{articles:errors:6}', layout: 'topRight', type: 'error', timeout: 1500 }).show();
    }
    function deleteMessage()
    {
        new Noty({ text: '{articles:messages:2}', type: 'success', timeout: 1500 }).show();
    }

    $(document).ready(function () {
        {if isset($messages.saved)}
	        new Noty({ text: 'Тип контента "{if isset($type.name)}{$type.name}{/if}" сохранен', type: 'success', timeout: 1500 }).show();
	    {/if}

        {if isset($errors.name)} new Noty({ text: 'Введите название контента', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Тип контента "{if isset($type.name)}{$type.name}{/if}" не сохранен', type: 'error', timeout: 2500 }).show(); {/if}

        {if isset($errors.fileName)} new Noty({ text: 'Введите название свойства на анг. языке', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameExists)} new Noty({ text: 'Введите название свойства на анг. языке', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameProhibited)} new Noty({ text: 'Такое название нельзя использовать', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameCharacters)} new Noty({ text: 'Имя файла может содержать только буквы', type: 'error', timeout: 2500 }).show(); {/if}

    });

    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('.sortable tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/field?action=reorder", { ids : ids }, function( data ) {
            $('.sortable_footer_navbar').removeClass('show');
            new Noty({ text: 'Поле перемещено', type: 'success', timeout: 1500 }).show();
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })

    // рабочее удаление id, заголовок, ссылка
    function removeField(id, title) {
        bootbox.confirm({
            closeButton: false,
            message: lang['sureToDelete'] + ' "'+title+'"?',
            callback: function(result) {
                if (result === true) {
                    $.post('index.php?mod=field&action=remove&id='+id, function (response) {
                        console.log(response);
                        if (response.status == 200) {
                            removeElement(id, 'field');
                        }
                        new Noty({ text: response.message, layout: 'topRight', type: response.type, timeout: 1500 }).show();

                    }, 'json');
                }
            }
        });
        return false;
    }

</script>




