
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/form?action=add{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-plus"></i></a>
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/forms" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/forms"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<div class="content">
	    <div class="row">
	        <div class="col-md-12">
	            <div class="card border shadow-sm">
		            <div class="">
			            <table class="table table-xs table-togglable table-striped table-hover" id="forms">
		                    <thead>
		                        <tr>
			                        <th class="text-center" width="30">#</th>
		                            <th data-toggle="true">Название формы</th>
		                            <th data-toggle="true">PATH</th>
		                            <th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
		                        </tr>
		                    </thead>
		                    {if !empty($forms)}
			                    <tbody class="sortable">
			                        {foreach item=form from=$forms name=forms}
			                        <tr id="form-{$form.formId}" data-id="{$form.formId}" data-value="{$form.fileName}" class="{if $form.status eq 'H'}table-warning{/if}">
				                        <td class="text-center text-nowrap"><i class="ph-dots-six text-muted"></i></td>
										<td class="text-start"><a href="{$adminUrl}/form?action=edit&id={$form.formId}">{$form.name nofilter}</a></td>
			                            <td class="text-start"> {$form.fileName nofilter}</td>
			                            <td class="text-center">
			                                <div class="d-inline-flex">
				                                <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/form?action=edit&id={$form.formId}"><i class="ph-note-pencil me-2"></i></a>
			                                    <div class="dropdown">
				                                    <a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

			                                        <div class="dropdown-menu dropdown-menu-end">
			                                            <a class="dropdown-item" href="{$adminUrl}/form?action=edit&id={$form.formId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
														{include file="components/actions/dropdown-status.tpl" module="forms" id=$form.formId status=$form.status scope=parent}
														{include file="components/actions/dropdown-delete.tpl" id=$form.formId title="{$form.name|escape|default:''}" module="forms" scope=parent}
			                                        </div>
			                                    </div>
			                                </div>
			                            </td>
			                        </tr>
			                        {/foreach}

			                    </tbody>
		                    {else}
		                        <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
		                    {/if}
	                    </table>
		            </div>

	                {include file="module/pagination.tpl" url="{$adminUrl}/forms" params="{$buildQueryString}"}

	            </div>
	        </div>
	    </div>
	</div>

	<script>
	    $(document).ready(function() {
	        {if isset($errors.not_saved)} new Noty({ text: '{socials:errors:3}', type: 'error', timeout: 1500 }).show(); {/if}
	        {if isset($messages.saved)} new Noty({ text: '{socials:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
	    });

		$(document).on('click', '.sortable_save_button', function () {
			const ids = [];
			document.querySelectorAll('.sortable tr').forEach(row => {
				const formId = row.getAttribute('data-id');
				const fileName = row.getAttribute('data-value');
				ids.push({ id: formId, fileName: fileName });
			});
			console.log(ids);
			fetch("{$adminUrl}/forms?action=reorder", {
				method: 'POST',
				headers: {
					'Content-Type': 'application/json'
				},
				body: JSON.stringify({ ids: ids })
			}).then(response => response.json()).then(response => {
				document.querySelector('.sortable_footer_navbar').classList.remove('show');
				new Noty({ text: response.message, type: response.type, timeout: 1500 }).show();

				if (response.status === 200) {
					setTimeout(() => {
						// location.reload();
					}, 1500);
				}
			}).catch(error => console.error('Error:', error));
		})

        $(document).on('click', '.sortable_cancel_button', function () {
			document.querySelector('.sortable_footer_navbar').classList.remove('show');
            location.reload();
        })

	</script>






