<!-- Inner content -->
<form method="post" id="section" enctype="multipart/form-data">

	{include file="components/group-buttons.tpl" url="{$adminUrl}/sections?{if !empty($page)}page={$page}{/if}{if !empty($parentId)}&parentId={$parentId}{/if}"}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/sections" class="breadcrumb-item">{$title|default:""}</a>
		<span class="breadcrumb-item active">{general:add}</span>
	{/capture}
	{capture name="showBy"}{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
		<div class="row">
			<div class="col-md-8">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.error_parent_type) || isset($errors.sectionType)}text-danger{/if}">{sections:sectionType}</label>
										{html_options options=$types selected=$section.type|default:'' name="section[type]" class="form-control select" id="type"}
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.error_parent_contentType) || isset($errors.error_contentType)}text-danger{/if}">{sections:contentType}</label>
										{html_options options=$contentTypes selected=$section.contentType|default:'default' name="section[contentType]" class="form-control select" id="contentType"}
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.parentId)}text-danger{/if}">{sections:general:parent}</label>
										{if isset($parents)}
											{if isset($section.parentId)}
												{html_options options=$parents selected=$section.parentId id="parentId" name="section[parentId]" class="form-control select"}
											{else}
												{html_options options=$parents id="parentId" selected=$parentId|default:'' name="section[parentId]" class="form-control select"}
											{/if}

										{else}
											<label class="form-label">{sections:general:na}</label>
											<input type="hidden" name="section[parentId]" value="0"/>
										{/if}
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.name)}text-danger{/if}">{sections:general:name}</label>
										<input type="text" class="form-control" autocomplete="off" id="name" name="section[name]" value="{$section.name|default:''}" />
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">{sections:general:alias}</label>
										<input type="text" class="form-control" autocomplete="off" id="alias" name="section[alias]" value="{$section.alias|default:''}"/>
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{sections:general:filename}</label>
										<input type="text" class="form-control" id="fileName" name="section[fileName]" value="{$section.fileName|default:''}" />
									</div>
								</div>

							</div>
						</div>
					</div>
				</div>

				{* фото галерея *}
				{include file="cards/card-gallery.tpl" galleries=$section.gallery|default:[] enable=$section.enableGallery|default:0 module='section'}
				{* /фото галерея *}

				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0 p-0">
							<textarea name="section[content]" class="description">{$section.content|default:''}</textarea>
						</div>
					</div>
				</div>
			</div>


			<div class="col-md-4">
				{* STATUS *}
				<div class="card border shadow-sm">

					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							{* field status *}
							{include file="components/fields/select.tpl" id="status" title="{general:status}" field="section[status]" array=$statuses selected=$section.status|default:'visible'  class="form-group mb-3"}
							{* /field status *}

							<div class="form-group mb-3">
								<label class="form-label">Тип ссылки <br /><i><code class="p-0">если нужно чтоб переходило на <b>стороний сайт</b> или перейти на какую то <b>другую страницу</b>, укажите (Внешняя ссылка) и <b>обязательно прописать ссылку</b></code></i></label>
								{html_options options=$urlTypes selected=$section.urlType|default:'' name="section[urlType]" class="form-control select selectUrlType" id="selectUrlType"}
							</div>
							<div class="form-group mb-3 external_link collapse {if !empty($section.urlType) AND $section.urlType eq 'external'}show{/if}" id="icon-urlType">
								<label class="form-label  {if isset($errors.externalLink)}text-danger{/if}">Ссылка <code>(t.me/@life)</code></label>
								<input type="text" class="form-control" id="link" name="section[externalLink]" value="{$section.externalLink|default:''}"/>
							</div>
							<div class="form-group mb-2">
								<div class="form-check form-check-inline">
									<input type="checkbox" class="form-check-input" id="headerMenu" name="section[headerMenu]" value="1" {if isset($section.headerMenu) and $section.headerMenu eq 1}checked{/if}>
									<label class="form-check-label" for="headerMenu">{sections:mainMenu}</label>
								</div>
							</div>
							<div class="form-group mb-2">
								<div class="form-check form-check-inline">
									<input type="checkbox" class="form-check-input" id="footerMenu" name="section[footerMenu]" value="1" {if isset($section.footerMenu) and $section.footerMenu eq 1}checked{/if}>
									<label class="form-check-label" for="footerMenu">{sections:footerMenu}</label>
								</div>
							</div>
							<div class="form-group mb-2">
								<div class="form-check form-check-inline">
									<input type="checkbox" class="form-check-input" id="enableGallery" name="section[enableGallery]" value="1" {if isset($section.enableGallery) and $section.enableGallery eq 1}checked{/if} data-bs-toggle="collapse" data-bs-target="#gallery-card" aria-expanded="{if isset($section.enableGallery) and $section.enableGallery eq 1}true{else}false{/if}">
									<label class="form-check-label" for="enableGallery">{sections:photoGallery}</label>
								</div>
							</div>
							<div class="mb-2">
								<div class="form-check form-check-inline mb-2">
									<input type="checkbox" class="form-check-input" id="enableIcon" name="section[enableIcon]" value="1" {if isset($section.enableIcon) and $section.enableIcon eq 1}checked{/if} data-bs-toggle="collapse" data-bs-target="#icon-enable" aria-expanded="{if isset($section.enableIcon) and $section.enableIcon eq 1}true{else}false{/if}">
									<label class="form-check-label" for="enableIcon">{sections:iconSection}</label>
								</div>

								<div class="form-group mb-3 collapse {if isset($section.enableIcon) and $section.enableIcon eq 1}show{/if}" id="icon-enable">
									<label class="form-label">{sections:icon}</label>
									<input type="text" class="form-control" autocomplete="off" id="icon" name="section[icon]" value="{$section.icon|default:''}"/>
								</div>
							</div>
						</div>
						<div class="card-footer hstack gap-3 justify-content-between">
							<div class="text-muted">
								<ul class="list list-unstyled mb-0 fs-sm">
									{if isset($section.addedOn)}<li>{general:created}</li>{/if}
									{if isset($section.modifiedOn)}<li>{general:modified}</li>{/if}
								</ul>
							</div>
							<div class="hstack gap-1">
								<ul class="list list-unstyled mb-0 fs-sm">
									{if isset($section.addedOn)}<li>{$section.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$section.addedBy.loginName|default:"{general:unknownUser}"})</li>{/if}
									{if isset($section.modifiedOn)} <li>{$section.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$section.modifiedBy.loginName|default:"{general:unknownUser}"})</li>{/if}
								</ul>
							</div>
						</div>
					</div>
				</div>


				{* IMAGE *}
				{include file="cards/card-image.tpl"
				image="{if isset($section.image)}{$section.image.original}{/if}"
				id="{if isset($section.image)}{$section.image.imageId}{/if}"
				module='section'}
				{* /IMAGE *}

				{* FILE *}
				{include file="cards/card-documents.tpl"
				cardName="Файлы (pdf, word)"
				docs=$section.docs|default:[]
				module='section'}
				{* /FILE *}

				{* SEO *}
				{include file="cards/card-seo.tpl"
				cardName="{general:card:seo}"
				content=$section|default:[]
				module='section'}
				{* /SEO *}

				{* SETTINGS *}
				<div class="card border shadow-sm card-collapsed">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:advanced}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse">
						<div class="card-body">
							{* Применение для данного *}
							<fieldset class="mb-3">
								<legend class="fs-base fw-bold border-bottom pb-2 mb-3">Применение для данного {general:section}</legend>

								<div class="mb-3">
									<label class="form-label">{general:template}</label>
									{html_options values=$templates output=$templates selected=$section.templateName|default:'' name="section[templateName]" class="form-control form-control-sm select"}
								</div>
								{* field isCached *}
								{include file="components/fields/select.tpl" id="isCached" title="{general:caching}" field="section[isCached]" array=$paramCaching selected=$section.isCached|default:0 class="form-group mb-2"}
								{* /field isCached *}

								<div class="mb-3">
									<div class="input-group">
										<button type="button" class="btn btn-success"><i class="icon-watch2"></i></button>
										{html_options options=$cachingTimeOptions  name="section[cacheTime]" selected=$section.cacheTime|default:1 class="form-control form-control-sm select" data-width="1%"}
										{html_options options=$cachingPeriodOptions name="section[cachePeriod]" selected=$section.cachePeriod|default:86400 class="form-control form-control-sm select" data-width="1%"}
									</div>
								</div>

								{* field commentsEnabled *}
								{include file="components/fields/select.tpl" id="commentsEnabled" title="{general:comments}" field="section[commentsEnabled]" array=$paramComments selected=$section.commentsEnabled|default:0 class="form-group mb-3"}
								{* /field commentsEnabled *}
							</fieldset>

							{* Применение для подразделов *}
							<fieldset class="form-group mb-3">
								<legend class="fs-base fw-bold border-bottom pb-2 mb-3">Применение для подразделов данного раздела</legend>
								<div class="mb-3">
									<label class="form-label">{general:template}</label>
									{html_options values=$templates output=$templates selected=$section.subTemplateName|default:'' name="section[subTemplateName]" class="form-control form-control-sm select"}
								</div>

								{* field subIsCached *}
								{include file="components/fields/select.tpl" id="subIsCached" title="{general:caching}" field="section[subIsCached]" array=$paramCaching selected=$section.subIsCached|default:0 class="form-group mb-2"}
								{* /field subIsCached *}

								<div class="mb-3">
									<div class="input-group">
										<button type="button" class="btn btn-success"><i class="icon-watch2"></i></button>
										{html_options options=$cachingTimeOptions name="section[subCacheTime]" selected=$section.subCacheTime|default:1  class="form-control form-control-sm select" data-width="1%"}
										{html_options options=$cachingPeriodOptions name="section[subCachePeriod]" selected=$section.subCachePeriod|default:86400  class="form-control form-control-sm select" data-width="1%"}
									</div>
								</div>

								{* field subCommentsEnabled *}
								{include file="components/fields/select.tpl" id="subCommentsEnabled" title="{general:comments}" field="section[subCommentsEnabled]" array=$paramComments selected=$section.subCommentsEnabled|default:0 class="form-group mb-3"}
								{* /field subCommentsEnabled *}
							</fieldset>

							{* Применение для контента *}
							<fieldset class="form-group mb-3">
								<legend class="fs-base fw-bold border-bottom pb-2 mb-3">Применение для контента данного раздела</legend>
								<div class="form-group mb-3">
									<label class="form-label">{general:template}</label>
									{html_options values=$templates output=$templates selected=$section.artTemplateName|default:'' name="section[artTemplateName]" class="form-control form-control-sm select"}
								</div>

								{* field artIsCached *}
								{include file="components/fields/select.tpl" id="artIsCached" title="{general:caching}" field="section[artIsCached]" array=$paramCaching selected=$section.artIsCached|default:0 class="form-group mb-2"}
								{* /field artIsCached *}

								<div class="input-group">
									<button type="button" class="btn btn-success"><i class="icon-watch2"></i></button>
									{html_options options=$cachingTimeOptions name="section[artCacheTime]" selected=$section.artCacheTime|default:1 class="form-control form-control-sm select" data-width="1%"}
									{html_options options=$cachingPeriodOptions name="section[artCachePeriod]" selected=$section.artCachePeriod|default:86400 class="form-control form-control-sm select" data-width="1%"}
								</div>
							</fieldset>

						</div>
					</div>
				</div>

			</div>

			<div class="col-md-12 main main_buttons text-center">
				{if isset($section.sectionId)}<input type="hidden" class="form-control" id="id" name="id" value="{$section.sectionId}">{/if}
				{$smarty.capture.buttons nofilter}
			</div>

		</div>
	</div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
	$(document).ready(function () {

		{if isset($messages.saved)} new Noty({ text: '{sections:messages:0}', type: 'success' }).show(); {/if}
		{if isset($messages.deleted)} new Noty({ text: '{sections:messages:1}', type: 'success' }).show(); {/if}
		{if isset($messages.sorted)} new Noty({ text: '{sections:messages:2}', type: 'success' }).show();{/if}

		{if isset($errors.not_saved)} new Noty({ text: '{sections:errors:0}', type: 'error' }).show(); {/if}
		{if isset($errors.section_not_found)} new Noty({ text: '{sections:errors:1}', type: 'error' }).show();{/if}
		{if isset($errors.name)} new Noty({ text: '{sections:errors:2}', type: 'error' }).show(); {/if}
		{if isset($errors.fileName)} new Noty({ text: '{sections:errors:3}', type: 'error' }).show(); {/if}
		{if isset($errors.fileNameExists)} new Noty({ text: '{sections:errors:4}', type: 'error' }).show(); {/if}
		{if isset($errors.htaccess)} new Noty({ text: '{sections:errors:5}', type: 'error' }).show(); {/if}
		{if isset($errors.serializations)} new Noty({ text: '{sections:errors:6}', type: 'error' }).show(); {/if}
		{if isset($errors.fileNameProhibited)} new Noty({ text: '{sections:errors:7}', type: 'error' }).show(); {/if}
		{if isset($errors.fileNameCharacters)} new Noty({ text: '{sections:errors:8}', type: 'error' }).show(); {/if}

		{if isset($errors.error_contentType)} new Noty({ text: '{sections:errors:13}', type: 'error' }).show(); {/if}
		{if isset($errors.error_parent_contentType)} new Noty({ text: '{sections:errors:15}', type: 'error' }).show(); {/if}
		{if isset($errors.error_parent_type)} new Noty({ text: '{sections:errors:16}', type: 'error' }).show(); {/if}
		{if isset($errors.sectionType)} new Noty({ text: '{sections:errors:13}', type: 'error' }).show(); {/if}
		{if isset($errors.externalLink)} new Noty({ text: 'Укажите ссылку на модальное окно или внешнюю ссылку', type: 'error' }).show(); {/if}


		const type = $('#type').val();
		if (type === 'plain') {
			const contentType = $('#contentType');
			if (contentType) {
				contentType.prop('disabled', true);
			}

			// Скрываем все элементы с классом "pages"
			// document.querySelectorAll('.pages').forEach(page => page.style.display = 'none');
		}

		$('#type').on('change', function() {
			const type = $(this).val();
			const contentType = $('#contentType');
			// const pages = document.querySelectorAll('.pages');

			if (type === 'plain') {
				contentType.val('default').trigger('change').prop('disabled', true); // Устанавливаем 'default' и отключаем
				// pages.forEach(page => page.style.display = 'none'); // Скрываем страницы
			} else {
				contentType.prop('disabled', false); // Включаем Select2
				// pages.forEach(page => page.style.display = ''); // Показываем страницы
			}
		});


		// Сохранение сортировки фотогалереи
		$(document).on('click', '.sortable_save_button', async function () {
			await handleGalleryAction('{$adminUrl}/section?action=sortPictures', false);
		});

		// Отмена сортировки
		$(document).on('click', '.sortable_cancel_button', function () {
			handleGalleryAction('{$adminUrl}/section?action=sortPictures', true);
		});


		document.addEventListener('click', function(event) {
			if (event.target && event.target.id === 'enableIcon') {
				const iconInput = document.querySelector('#icon');
				if (!event.target.checked) {
					iconInput.value = '';
				}
			}
		});

		$('#selectUrlType').change(function(e) {
			const selectedValue = e.target.value; // Значение выбранного элемента

			const externalLink = document.querySelector('.external_link');
			if (!externalLink) return; // Проверяем наличие элемента

			// Управляем классом 'show' в зависимости от значения
			externalLink.classList.toggle('show', selectedValue === 'external');
		});

	});

	$(function () { function e() { alias_touched || $("#alias").val(a()), keywords_touched || $("#keywords").val(i()), description_touched || $("#description").val(t()), fileName_touched || $("#fileName").val(n()) } function a() { return name = $("#name").val() } function m() { return name = $("#name").val() } function i() { return name = $("#name").val() } function t() { return name = $("#name").val() } function n() { return fileName = $("#name").val(), fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"), fileName = l(fileName), fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase() } function l(e) { for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"), i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"), t = "", n = 0, l = e.length; l > n; n++) {
		var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o
	} return t }
		alias_touched = !0,
				keywords_touched = !0,
				description_touched = !0,
				fileName_touched = !0,
		($("#alias").val() == a() || "" == $("#alias").val()) && (alias_touched = !1),
		($("#keywords").val() == i() || "" == $("#keywords").val()) && (keywords_touched = !1),
		($("#description").val() == t() || "" == $("#description").val()) && (description_touched = !1),
		($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1),
				$("#alias").change( function () { alias_touched = !0 }),
				$("#keywords").change( function () { keywords_touched = !0 }),
				$("#description").change( function () { description_touched = !0 }),
				$("#fileName").change( function () { fileName_touched = !0 }),
				$("#name").keyup( function () { e() })
	});

</script>


