<form method="post" class="needs-validation" novalidate>

	<!-- Page header -->
	{include file="components/group-buttons.tpl" url="{$adminUrl}/groups{if !empty($page)}?page={$page}{/if}"}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/groups" class="breadcrumb-item">{$title|default:""}</a>
	{/capture}

	{capture name="showBy"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<!-- Content area -->
	<div class="content">

		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:tabs:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-3">
									<div class="form-group mb-3">
										<label for="name" class="form-label {if isset($errors.nameEmpty)}text-danger{/if}">Роль</label>
										<input type="text" class="form-control" autocomplete="off" id="name" name="group[name]" value="{$group.name|default:''}"  required=""/>
									</div>
								</div>
								<div class="col-md-3">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.fileNameEmpty) || isset($errors.fileNameExists) || isset($errors.fileNameCharacters)}text-danger{/if}">Символ (A, B, C) на латинице</label>
{*										<input type="text" class="form-control" id="fileName" name="group[fileName]" value="{$group.fileName|default:''}" maxlength="1"  required=""/>*}
										{html_options options=$groups selected=$group.fileName|default:'' id="groups" name="group[fileName]" class="form-control select"}
									</div>
								</div>

{*								{include file="components/fields/select.tpl" col="col-md-3" id="groups" title="Доступ к админ панели" field="group[fileName]" array=$groups selected=$group.hasAdminAccess|default:1 class="form-group mb-3"}*}
								{* field choices *}
								{include file="components/fields/select.tpl" col="col-md-3" id="choices" title="Доступ к админ панели" field="group[hasAdminAccess]" array=$choices selected=$group.hasAdminAccess|default:1 class="form-group mb-3"}
								{* /field choices *}

								{* field status *}
								{include file="components/fields/select.tpl" col="col-md-3" id="status" title="{general:status}" field="group[status]" array=$statuses selected=$group.status|default:'V' class="form-group mb-3"}
								{* /field status *}

								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label">Описание</label>
										<textarea rows="3" cols="3" class="form-control" name="group[description]" placeholder="Описание">{$group.description|default:''}</textarea>
									</div>
								</div>
							</div>
						</div>
						{if isset($group.addedOn) && isset($group.modifiedOn)}
							<div class="card-footer hstack gap-3 justify-content-between">
								<div class="text-muted">
									<ul class="list list-unstyled mb-0 fs-sm">
										<li>Пользователей группы</li>
										<li>{general:created}</li>
										<li>{general:modified}</li>
									</ul>
								</div>
								<div class="hstack gap-1">
									<ul class="list list-unstyled mb-0 fs-sm">
										<li>{$group.countUsers|default:0}</li>
										<li>{$group.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$group.addedBy.loginName|default:"{general:unknownUser}"})</li>
										<li>{$group.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$group.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
									</ul>
								</div>
							</div>
						{/if}
					</div>
				</div>
			</div>
			{* права доступа *}
			<div class="col-md-12">
				<div class="alert bg-info text-white alert-styled-left alert-dismissible">
{*					<span class="font-weight-semibold">Указать привилегии к пунктам меню</span> которые будут отображаться только для этой группы пользователей, с ограничениями доступа к другим пунктам меню.*}
					<span class="font-weight-semibold">Укажите привилегии для пунктов меню</span>, доступных исключительно данной группе пользователей. Определите, к каким разделам они смогут получить доступ, и ограничения на просмотр и использование остальных пунктов меню для этой группы.
				</div>
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0 {if isset($errors.privilegesEmpty)}text-danger{/if}">Настроить привилегии для этой роли сотрудника</h6>
						<div class="d-inline-flex ms-auto">
							<div class="form-check form-check-inline">
								<input type="checkbox" class="form-check-input form-check-input-info  all_perms" id="all_perms" value="">
								<label class="form-check-label" for="all_perms">Все пункты меню</label>
							</div>
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row">
							<div class="boxed fn_toggle_wrap">
								{* права доступа *}
								{strip}
									<div class="toggle_body_wrap on fn_card">
										{foreach $permission as $title => $items}
											<div class="card-body bg-light permission_block mb-2">
												{if isset($items.children)}
													<h6 class="fw-semibold">{$items.name}</h6>
													<div class="permission_boxes row fn_perms_wrap">
														{foreach $items.children as $key => $item}
															<div class="col-xl-2 col-lg-3 col-md-6 mb-2">
																<div class="permission_box">
																	<div class="form-check form-check-inline">
																		<input type="checkbox" class="form-check-input form-check-input-info item_perm" id="{$item.fileName}_{$key}" name="privileges[]" value="{$item.fileName}" {if isset($group.privilege) &&  in_array($item.fileName, $group.privilege)}checked{/if}>
																		<label class="form-check-label" for="{$item.fileName}_{$key}">{$item.name|escape}</label>
																	</div>
																</div>
															</div>
														{/foreach}
													</div>
												{else}
													<div class="permission_boxes row fn_perms_wrap">
														<div class="col-xl-2 col-lg-3 col-md-6 mb-2">
															<div class="permission_box">
																<div class="form-check form-check-inline">
																	<input type="checkbox" class="form-check-input form-check-input-info item_perm" id="{$items.fileName}_{$title}" name="privileges[]" value="{$items.fileName}" {if isset($group.privilege) &&  in_array($items.fileName, $group.privilege)}checked{/if}>
																	<label class="form-check-label" for="{$items.fileName}_{$title}">{$items.name|escape}</label>
																</div>
															</div>
														</div>
													</div>
												{/if}
											</div>
										{/foreach}
									</div>
								{/strip}
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="col-md-12 text-center">
				{if isset($group.groupId)}<input type="hidden" class="form-control" id="id" name="id" value="{$group.groupId|default:''}">{/if}
				{$smarty.capture.buttons nofilter}
			</div>
		</div>

	</div>
</form>

<script>
	$(document).ready(function () {
		{if isset($errors.nameEmpty)}     		new Noty({ text: 'Введите название роли.', type: 'error' }).show(); {/if}
		{if isset($errors.fileNameEmpty)}     	new Noty({ text: 'Укажите символом группы на латинице.', type: 'error' }).show(); {/if}
		{if isset($errors.fileNameExists)}    	new Noty({ text: 'Группа с таким символом уже существует', type: 'error' }).show(); {/if}
		{if isset($errors.fileNameCharacters)} 	new Noty({ text: 'Символ может содержать только следующие символы: A-Z', type: 'error' }).show(); {/if}
		{if isset($errors.privilegesEmpty)} 	new Noty({ text: 'У группы пользователей должна быть хотя бы одна привилегия.', type: 'error' }).show(); {/if}

		{if isset($errors.not_saved)} new Noty({ text: 'Группа не сохранена', type: 'error' }).show(); {/if}
		{if isset($messages.saved)}   new Noty({ text: 'Группа сохранена', type: 'success' }).show(); {/if}

	});

	document.addEventListener("change", function(event) {
		if (event.target.classList.contains("all_perms")) {
			const allPermsChecked = event.target.checked;
			const itemPerms = document.querySelectorAll(".item_perm");

			itemPerms.forEach(function(item) {
				if (item.checked !== allPermsChecked) {
					item.click(); // Trigger a click on the item
				}
			});
		}
	});
</script>

