<?php

namespace Mnv\Core;

use Mnv\Core\Singleton\SingletonTrait;

/**
 * Singleton-класс для работы с картами
 */
class Maps
{
    use SingletonTrait;

    /** @var array|null Хранит значения карты */
    private ?array $_mapValues = null;

    /**
     * Загружает значения карты из конфигурационного файла, если они еще не загружены.
     *
     * @return void
     */
    private function loadMapValues(): void
    {
        if ($this->_mapValues === null) {
            $filePath = GLOBAL_ROOT . '/includes/config.maps.inc.php';

            if (!file_exists($filePath)) {
                throw new \RuntimeException("Файл конфигурации карты не найден: {$filePath}");
            }

            $this->_mapValues = require $filePath;

            if (!is_array($this->_mapValues)) {
                throw new \UnexpectedValueException('Загруженные значения карты должны быть массивом.');
            }
        }
    }

    /**
     * Возвращает значения карты.
     *
     * @return array|null Массив значений карты или null, если они недоступны.
     */
    public function getMapValues(): ?array
    {
        if ($this->_mapValues === null) {
            $this->loadMapValues();
        }

        return $this->_mapValues;
    }
}