<?php

namespace Mnv\Core\Sms;

/**
 *  Class GetSms
 *
 * @package Mnv\Core\Sms
 */
class GetSms extends SmsGateway
{

    /** @var string $sendUrl  */
    protected string $endpoint = 'http://185.8.212.184/smsgateway/';

    /**
     *  Отправка смс с кодом активации
     *
     * @param string $number @номер телефона
     * @param string $text @текст отправляемый в смс
     * @return bool
     */
    public function send(string $number, string $text): bool
    {
        $this->sms = [
            [
                'phone' => $number,
                'text'  => $text,
            ]
        ];

        $data = $this->requestCurl();
        return $data == 'Request is received';
    }


    /**
     * Curl Отправка и получение ответа server
     * @return string|null
     */

    private function requestCurl(): ?string
    {
        $curl = curl_init();

        $data = 'login='.urlencode($this->smsLogin);
        $data .= '&password='.urlencode($this->smsPass);
        if (isset($this->nickname)) {
            $data .= '&nickname='.urlencode($this->nickname);
        }

        $data .= '&data='.urlencode(json_encode($this->sms));

        curl_setopt($curl, CURLOPT_URL, $this->endpoint);
        curl_setopt($curl, CURLOPT_HEADER, 0);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($curl, CURLOPT_TIMEOUT, 5);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
//        curl_setopt($curl, CURLOPT_POSTFIELDS,
//            'login='.urlencode($this->smsLogin).'&password='.urlencode($this->smsPass).
//                //'&nickname='.urlencode(this->nickname).
//                '&data='.urlencode(json_encode($this->sms)));


        curl_setopt($curl, CURLOPT_USERAGENT, 'Opera 10.00');
        $res = curl_exec($curl);

        curl_close($curl);

        return $res;
    }
}