<?php

namespace Mnv\Core\Sms;

use http\Exception\InvalidArgumentException;

/**
 *  Class SMSFactory
 *
 * @package Mnv\Core\Sms
 */

class SMSFactory
{

    /**
     * Map of provider names to their respective classes.
     *
     * @var array
     */
    private static $providers = [
        'getsms' => GetSms::class,
        'paymobile' => PayMobileSms::class,
        // Add more providers here as needed
    ];

    /**
     * Returns an instance of the requested SMS provider.
     *
     * @param string $provider The name of the provider.
     * @return object An instance of the requested provider class.
     * @throws InvalidArgumentException if the provider is not supported.
     */
    public static function adapt($provider)
    {
        if (!isset(self::$providers[$provider])) {
            throw new InvalidArgumentException('Wrong choice of provider');
        }

        $providerClass = self::$providers[$provider];
        return new $providerClass();
    }

    /**
     * Adds a new provider to the providers list.
     *
     * @param string $provider The name of the provider.
     * @param string $providerClass The class name of the provider.
     * @return void
     */
    public static function addProvider($provider, $providerClass)
    {
        self::$providers[$provider] = $providerClass;
    }

}