<?php

namespace Mnv\Core\Uploads;

/**
 * Class ImagineGeneratorFactory
 * @package Mnv\Core\Uploads
 */

class GeneratorFactory
{
    /**
     * @param $realPath
     * @param $path
     * @param  string|null  $uuid
     * @param $managerId
     *
     * @return ImagineGenerator
     */
    public static function imagineGenerator($realPath, $path, ?string $uuid, $managerId): ImagineGenerator
    {
        return new ImagineGenerator($realPath, $path, $uuid, $managerId);
    }

    /**
     * @param $realPath
     * @param $path
     * @param  string|null  $uuid
     * @param $managerId
     *
     * @return ImageGenerator
     */
    public static function imageGenerator($realPath, $path, ?string $uuid, $managerId): ImageGenerator
    {
        return new ImageGenerator($realPath, $path, $uuid, $managerId);
    }
}