<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class Countries
 * @package Mnv\Models
 */
class GeoCountries extends Model
{
    /** @var string */
    protected string $table = 'geo_countries';
    /** @var string  */
    protected string $primaryKey = 'id';

    protected string $orderBy = 'id ASC';

    public ?array $translations = [];
    public function __construct(Request $request)
    {
        $this->id   = $request->get('id');
        $this->data = $request->get('country');
        $this->translations = $request->get('translations');
    }


    /** фильтрация / сортировка */
    protected function sorting(): void
    {
        if (!empty($this->filter['status'])) {
            connect()->where('status', $this->filter['status']);
        }

        if (!empty($this->filter['query'])) {
            connect()->grouped(function($q) {
                $q->like('name', "%" . $this->filter['query'] . "%")
                    ->orLike('numericCode', "%" . $this->filter['query'] . "%")
                    ->orLike('phoneCode',"%" . $this->filter['query'] . "%");
            });
        }

    }

    /** Получение всех статей */
    public function all($limit, $page)
    {
        /** фильтрация / сортировка */
        $this->sorting();

        return parent::all($limit, $page);
    }

    /** Получение кол-во контента */
    public function total(): void
    {
        /** фильтрация / сортировка */
        $this->sorting();
        parent::total();
    }


    public function prepare(array $data, int $managerId): bool
    {
        $data['modifiedBy']    = $managerId;
        $data['modifiedOn']    = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {
            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');

            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }

    /**
     * Retrieves a list of countries from the 'geo_countries' database table.
     * The selected fields are 'id', 'name', 'phoneCode', and 'iso2'.
     * Only countries with the status 'V' are included.
     * The results are sorted in ascending order by 'id'.
     *
     * @return array An array of associative arrays representing
     */
    public static function getSelectCountries(): array
    {
        return connect( 'geo_countries')->select('id, name, phoneCode, iso2')->where('status', 'V')->orderBy('id ASC')->getAll('array') ?? [];
    }

    public static function getCountryName($countryId)
    {
        return connect('geo_countries')->select('name')->where('id', $countryId)->getValue();

    }

    public function checkFileName(?string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }

}