<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Http\Request;

/**
 * Class GeoDistricts
 * @package Mnv\Models
 */
class GeoDistricts extends Model
{
    /** @var string */
    protected string $table = 'geo_districts';

    /** @var string  */
    protected string $primaryKey = 'id';

    /** @var string  */
    protected string $orderBy = 'orderBy ASC';

    /** @var array  */
    public $ids = [];

    public function __construct(Request $request)
    {
        $this->id   = $request->get('id');
        $this->data = $request->get('district');
        $this->ids = $request->get('ids');
    }


    public function prepare(array $data, int $managerId): bool
    {
        $data['modifiedBy']    = $managerId;
        $data['modifiedOn']    = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {
            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = $this->getMaxValue('orderBy') + 1;

            if ($this->id = $this->insert($data)) {
                return true;
            }
        }
        else {
            return $this->update($data);
        }

        return false;
    }

    /**
     * @return array|false|mixed|string
     */
    public static function getSelectDistricts()
    {
        return connect()->table( 'geo_districts')->select('id, name')->orderBy('name ASC')->indexKey('id')->valueKey('name')->getAllIndexes();
    }


    public function checkFileName(?string $fileName)
    {
        // TODO: Implement checkFileName() method.
    }

}