<?php


namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Core\Collections\Collection;

/**
 * Class Logs
 * @package Mnv\Models
 */
class Logs extends Model
{

    /** @var string */
    protected string $table = 'log';

    protected string $orderBy = 'date_log DESC';

    protected string $columns = 'userId, message, type_log, date_log, loginName';

    /** показать все */
    public function all($limit, $page)
    {
        connect()->usingJoin('users','userId');
        return parent::all($limit, $page);
    }


    /**
     * Очещение журнала
     */
    public function clear(): bool
    {
        connect($this->table)->delete();

        return true;
    }


}