<?php

require_once 'overall.inc.php';

global $visitorSessionName, $smarty;

use Mnv\Core\BotBlockIp;
use Mnv\Core\ConfigManager;
use Mnv\Core\Security\Csrf\SecurityCsrfSessionProvider;
use Mnv\Core\Security\Csrf\SecurityCsrfToken;
use Mnv\Core\Utilities\Cookie\Cookie;
use Mnv\Core\Utilities\Cookie\Session;

// Проверка текущего ip-адреса
BotBlockIp::checkIp();

$adminIp = '';
$userIp = request()->ip();
if (!empty(ConfigManager::getValue('listIp'))) {
    $listIps = explode(",", ConfigManager::getValue('listIp'));
    foreach ($listIps as $listIp) {
        if ($listIp == $userIp) {
            $adminIp = $listIp;
        }
    }
}

/** если сайте отключен вывести шаблон или сообщение */
if (ConfigManager::getValue('website_down') == 0 && $adminIp == '') {
    header("HTTP/1.0 503 Service Unavailable");
    if (file_exists(THEME_ROOT.'/maintenance.tpl')) {
        $smarty->display('maintenance.tpl');
    } else {
        print "<html><head><title>Сервис недоступен</title><style> html, body {height : 100vh;width : 100%;overflow : hidden;margin: 0 auto;font-family: -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Oxygen-Sans,Ubuntu,Cantarell,'Helvetica Neue',sans-serif;}.wrapper {height : 100%;width : 100%;padding: 0px;text-align: center;}.content {position:absolute; width:100%; top:50%;transform: translateY(-100%);}h3{color: #424242;font-weight: 400;}</style></head><body><div class='wrapper'><div class='content'><h3>".nl2br(ConfigManager::getValue('maintenance_message'))."</h3></div></div></body></html>";
    }
    exit;
}

	/* сессия */
if (\session_status() == \PHP_SESSION_NONE) {
    // использовать файлы cookie для хранения идентификаторов сеансов
    \ini_set('session.use_cookies', 1);
    // использовать только файлы cookie (не отправлять идентификаторы сеанса в URL-адресах)
    \ini_set('session.use_only_cookies', 1);
    // не отправлять идентификаторы сеанса в URL-адресах
    \ini_set('session.use_trans_sid', 0);

    try {
        // запустить сеанс (запрашивает запись cookie на клиенте)
        Session::start($visitorSessionName);
    } catch (\Exception $e) {
        error_log("Session :: " . $e->getMessage());
    }
}

$smarty->assign('sessionId', Session::id());
Cookie::setcookie($visitorSessionName, Session::id(),time() + 604800, '/', '', '', true, 'Lax');

// хранение токена в сессии
$securityCsrfToken = new SecurityCsrfToken(new SecurityCsrfSessionProvider());
