<?php

use Mnv\Core\ConfigManager;
use Mnv\Core\Utilities\Cookie\Session;

require_once '../includes/visitor.inc.php';

$time_start = microtime(true);

	$sectionId 	= (int) request()->get('sectionId');
	$page      	= (int) request()->get('page');
	$rewrite   	= request()->get('rewrite');
    $query      = request()->get('query');

    if (!empty($SECTIONS[$sectionId])) {
		$section = prepareSection($SECTIONS[$sectionId]);
		$smarty->assign('section', $section);
	} else {
		header("HTTP/1.0 301 Moved Permanently");
		header("Location: ".SITE_URL."/");

		/* saving visit */
		writeErrorVisit(301);
		exit;
	}

	/* checking whether we in rewrite mode */
	if ($rewrite != ConfigManager::getValue('rewrite')) {
		header("HTTP/1.0 301 Moved Permanently");
        header("Location: $section[url]");

		/* saving visit */
		writeErrorVisit(301);
		exit;
	}

    $requestUri = $_SERVER["REQUEST_URI"];
    $countReplace = 0;
    $replaced_url = preg_replace('/\/\/+/', '/', $requestUri, -1, $countReplace);
    if ($countReplace > 0) {
        header("HTTP/1.0 301 Moved Permanently");
        header("Location: $section[url]");
        exit;
    }

	/* caching procedures */
	if ($section['isCached'] == 1) {
		$smarty->caching( 2, $section['cacheTime'] * $section['cachePeriod']);
	} elseif ($section['isCached'] != -1 && ConfigManager::getValue('cache_enabled_section') == 1) {
		$smarty->caching = 2;
        $smarty->caching( 2, ConfigManager::getValue('cache_time_section') * ConfigManager::getValue('cache_period_section'));
	}

	if ($page < 1) $page = 1;
    $smarty->assign('page', $page);

	/* for "you-are-here" navigation */
	$sectionParents = getSectionParents($sectionId);
	$section['parent'] = getSectionParent($section['parentId']);

	$smarty->assign('sectionParents', $sectionParents);
	$smarty->assign('activeSection', $SECTIONS[$sectionId]);


    $params = [];
    if (!empty($query)) $params['query'] = $query;

    $queryString = !empty($params) ? '&' . http_build_query(array_filter($params)) : '';
    $smarty->assign('queryString',  preg_replace( '/^.(.*)$/', '\1', $queryString ));

    $smarty->assign('query', $query);

	/* saving visit */
	writeSectionVisit($sectionId, $page);

    $templateName = empty($section['templateName']) ? ($section['type'] == 'tree' ? 'section.tpl' : 'page.tpl') : $section['templateName'];
	$smarty->display($templateName, "$sectionId-$page".SITE_LANG_POSTFIX);

	/* precise load time */
	updateLoadTime();

if (DEBUG) {
    // Отладочная информация
    $time_end = microtime(true);
    $exec_time = $time_end - $time_start;

// Форматирование отладочных данных
    $debugInfo = [
        'php_version' => phpversion(),
        'memory' => [
            // Это значение показывает максимальное количество памяти (в байтах), которое скрипт потребил на момент выполнения.
            'peak_usage_bytes' => memory_get_peak_usage(),
            // То же, что и peak_usage_bytes, но результат переведен в мебибайты (MiB) для удобства чтения.
            'peak_usage_mib' => number_format(memory_get_peak_usage(true) / 1024 / 1024, 2, '.', '') . ' MiB',
            // Это текущее количество памяти (в байтах), которое использует скрипт на момент вызова функции.
            'current_usage_bytes' => memory_get_usage(),
            // Текущее потребление памяти, переведенное в мебибайты
            'current_usage_mib' => number_format(memory_get_usage() / 1024 / 1024, 2, '.', '') . ' MiB',
        ],
        'execution' => [
            'page_generation_time_sec'  => number_format($exec_time, 4, '.', ''), // Альтернативное округление
            'php_run_time_sec'          => number_format($exec_time, 4, '.', ''),
        ],
        'queries' => [
            'query_count' => connect()->queryCount(),
        ],
        'server' => [
            'request_uri'   => $_SERVER['REQUEST_URI'] ?? '',
            'method'        => $_SERVER['REQUEST_METHOD'] ?? '',
            'ip'            => $_SERVER['REMOTE_ADDR'] ?? '',
            'user_agent'    => $_SERVER['HTTP_USER_AGENT'] ?? '',
        ],
    ];

// Вывод отформатированной отладочной информации
    echo "\n<!-- Debug Info: " . json_encode($debugInfo, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES) . " -->";
}
?>