{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main">

	<section class="intro">

		{* banner *}
		{include file="modules/banner-page.tpl" class="intro__bg"}
		{* /banner *}

		<div class="flex:col-max">
			<div class="intro__desc">
				<div class="text-tmp title-64 title-tt-up txt-20 sub-title-white color-white gap-all-30">
					<p>{$section.alias}</p>
					<h1>{$section.name|replace:"LLC":"<span>LLC</span>" nofilter}</h1>
					{$section.content|page_break:null nofilter}
				</div>
			</div>
		</div>

	</section>

	{fetch_sections assign=others from=$section.sectionId status="V" getContent=true getImage=true}{if !empty($others)}
		{foreach from=$others item=other name=others}
			{if $smarty.foreach.others.iteration%2!=0}
				{* Корпоративная Ответственность *}
				<section class="both reverse bg-white">
					<div class="both__item">
						<div class="both__img">
							<img src="{$other.image.original|default:''}" alt="{$other.name}">
						</div>
					</div>

					<div class="both__item">
						<div class="both__desc">
							<div class="text-tmp title-48 txt-18 gap-all-20">
								<h2>{$other.name}</h2>
								{$other.content|page_break:null nofilter}
							</div>
						</div>
					</div>
				</section>
				{* Корпоративная Ответственность *}
			{else}
				{* Мы больше чем просто компания *}
				<section class="block-text">
					<div class="flex:col-max">
						<div class="grid:fr-1 g-gap-40">
							<div class="head border-bot-white">
								<div class="head__item">
									<div class="text-tmp title-48 txt-20 color-white gap-all-20">
										<h2>{$other.name}</h2>
									</div>
								</div>
							</div>
							<div class="text-tmp title-48 txt-20 color-white gap-all-20">
								{$other.content|page_break:null nofilter}
							</div>
						</div>
					</div>
					<div class="block-text__img">
						<img src="{$other.image.original|default:''}" alt="{$other.name}">
					</div>
				</section>
				{* /Мы больше чем просто компания *}
			{/if}
		{/foreach}
	{/if}
</main>

{include file="footer.tpl"}